/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sceneitems;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class DuplicateSceneItemRequest
extends Request<SpecificData> {
    private DuplicateSceneItemRequest(String sceneName, Number sceneItemId, String destinationSceneName) {
        super(RequestType.DuplicateSceneItem, SpecificData.builder().sceneName(sceneName).sceneItemId(sceneItemId).destinationSceneName(destinationSceneName).build());
    }

    public static DuplicateSceneItemRequestBuilder builder() {
        return new DuplicateSceneItemRequestBuilder();
    }

    @Override
    public String toString() {
        return "DuplicateSceneItemRequest(super=" + super.toString() + ")";
    }

    public static class DuplicateSceneItemRequestBuilder {
        private String sceneName;
        private Number sceneItemId;
        private String destinationSceneName;

        DuplicateSceneItemRequestBuilder() {
        }

        public DuplicateSceneItemRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public DuplicateSceneItemRequestBuilder sceneItemId(Number sceneItemId) {
            this.sceneItemId = sceneItemId;
            return this;
        }

        public DuplicateSceneItemRequestBuilder destinationSceneName(String destinationSceneName) {
            this.destinationSceneName = destinationSceneName;
            return this;
        }

        public DuplicateSceneItemRequest build() {
            return new DuplicateSceneItemRequest(this.sceneName, this.sceneItemId, this.destinationSceneName);
        }

        public String toString() {
            return "DuplicateSceneItemRequest.DuplicateSceneItemRequestBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ", destinationSceneName=" + this.destinationSceneName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private Number sceneItemId;
        private String destinationSceneName;

        SpecificData(@NonNull String sceneName, @NonNull Number sceneItemId, String destinationSceneName) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (sceneItemId == null) {
                throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.sceneItemId = sceneItemId;
            this.destinationSceneName = destinationSceneName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public Number getSceneItemId() {
            return this.sceneItemId;
        }

        public String getDestinationSceneName() {
            return this.destinationSceneName;
        }

        public String toString() {
            return "DuplicateSceneItemRequest.SpecificData(sceneName=" + this.getSceneName() + ", sceneItemId=" + this.getSceneItemId() + ", destinationSceneName=" + this.getDestinationSceneName() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private Number sceneItemId;
            private String destinationSceneName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder sceneItemId(@NonNull Number sceneItemId) {
                if (sceneItemId == null) {
                    throw new IllegalArgumentException("sceneItemId is marked non-null but is null");
                }
                this.sceneItemId = sceneItemId;
                return this;
            }

            public SpecificDataBuilder destinationSceneName(String destinationSceneName) {
                this.destinationSceneName = destinationSceneName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.sceneItemId, this.destinationSceneName);
            }

            public String toString() {
                return "DuplicateSceneItemRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", sceneItemId=" + this.sceneItemId + ", destinationSceneName=" + this.destinationSceneName + ")";
            }
        }
    }
}

