/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.sceneitems;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class CreateSceneItemRequest
extends Request<SpecificData> {
    private CreateSceneItemRequest(String sceneName, String sourceName, Boolean sceneItemEnabled) {
        super(RequestType.CreateSceneItem, SpecificData.builder().sceneName(sceneName).sourceName(sourceName).sceneItemEnabled(sceneItemEnabled).build());
    }

    public static CreateSceneItemRequestBuilder builder() {
        return new CreateSceneItemRequestBuilder();
    }

    @Override
    public String toString() {
        return "CreateSceneItemRequest(super=" + super.toString() + ")";
    }

    public static class CreateSceneItemRequestBuilder {
        private String sceneName;
        private String sourceName;
        private Boolean sceneItemEnabled;

        CreateSceneItemRequestBuilder() {
        }

        public CreateSceneItemRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public CreateSceneItemRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public CreateSceneItemRequestBuilder sceneItemEnabled(Boolean sceneItemEnabled) {
            this.sceneItemEnabled = sceneItemEnabled;
            return this;
        }

        public CreateSceneItemRequest build() {
            return new CreateSceneItemRequest(this.sceneName, this.sourceName, this.sceneItemEnabled);
        }

        public String toString() {
            return "CreateSceneItemRequest.CreateSceneItemRequestBuilder(sceneName=" + this.sceneName + ", sourceName=" + this.sourceName + ", sceneItemEnabled=" + this.sceneItemEnabled + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private String sourceName;
        private Boolean sceneItemEnabled;

        SpecificData(@NonNull String sceneName, @NonNull String sourceName, Boolean sceneItemEnabled) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.sourceName = sourceName;
            this.sceneItemEnabled = sceneItemEnabled;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        public Boolean getSceneItemEnabled() {
            return this.sceneItemEnabled;
        }

        public String toString() {
            return "CreateSceneItemRequest.SpecificData(sceneName=" + this.getSceneName() + ", sourceName=" + this.getSourceName() + ", sceneItemEnabled=" + this.getSceneItemEnabled() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private String sourceName;
            private Boolean sceneItemEnabled;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder sceneItemEnabled(Boolean sceneItemEnabled) {
                this.sceneItemEnabled = sceneItemEnabled;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.sourceName, this.sceneItemEnabled);
            }

            public String toString() {
                return "CreateSceneItemRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", sourceName=" + this.sourceName + ", sceneItemEnabled=" + this.sceneItemEnabled + ")";
            }
        }
    }
}

