/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.outputs;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class ToggleOutputRequest
extends Request<SpecificData> {
    private ToggleOutputRequest(String outputName) {
        super(RequestType.ToggleOutput, SpecificData.builder().outputName(outputName).build());
    }

    public static ToggleOutputRequestBuilder builder() {
        return new ToggleOutputRequestBuilder();
    }

    @Override
    public String toString() {
        return "ToggleOutputRequest(super=" + super.toString() + ")";
    }

    public static class ToggleOutputRequestBuilder {
        private String outputName;

        ToggleOutputRequestBuilder() {
        }

        public ToggleOutputRequestBuilder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public ToggleOutputRequest build() {
            return new ToggleOutputRequest(this.outputName);
        }

        public String toString() {
            return "ToggleOutputRequest.ToggleOutputRequestBuilder(outputName=" + this.outputName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String outputName;

        SpecificData(@NonNull String outputName) {
            if (outputName == null) {
                throw new IllegalArgumentException("outputName is marked non-null but is null");
            }
            this.outputName = outputName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getOutputName() {
            return this.outputName;
        }

        public String toString() {
            return "ToggleOutputRequest.SpecificData(outputName=" + this.getOutputName() + ")";
        }

        public static class SpecificDataBuilder {
            private String outputName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder outputName(@NonNull String outputName) {
                if (outputName == null) {
                    throw new IllegalArgumentException("outputName is marked non-null but is null");
                }
                this.outputName = outputName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.outputName);
            }

            public String toString() {
                return "ToggleOutputRequest.SpecificData.SpecificDataBuilder(outputName=" + this.outputName + ")";
            }
        }
    }
}

