/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.outputs;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class StartOutputRequest
extends Request<SpecificData> {
    private StartOutputRequest(String outputName) {
        super(RequestType.StartOutput, SpecificData.builder().outputName(outputName).build());
    }

    public static StartOutputRequestBuilder builder() {
        return new StartOutputRequestBuilder();
    }

    @Override
    public String toString() {
        return "StartOutputRequest(super=" + super.toString() + ")";
    }

    public static class StartOutputRequestBuilder {
        private String outputName;

        StartOutputRequestBuilder() {
        }

        public StartOutputRequestBuilder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public StartOutputRequest build() {
            return new StartOutputRequest(this.outputName);
        }

        public String toString() {
            return "StartOutputRequest.StartOutputRequestBuilder(outputName=" + this.outputName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String outputName;

        SpecificData(@NonNull String outputName) {
            if (outputName == null) {
                throw new IllegalArgumentException("outputName is marked non-null but is null");
            }
            this.outputName = outputName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getOutputName() {
            return this.outputName;
        }

        public String toString() {
            return "StartOutputRequest.SpecificData(outputName=" + this.getOutputName() + ")";
        }

        public static class SpecificDataBuilder {
            private String outputName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder outputName(@NonNull String outputName) {
                if (outputName == null) {
                    throw new IllegalArgumentException("outputName is marked non-null but is null");
                }
                this.outputName = outputName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.outputName);
            }

            public String toString() {
                return "StartOutputRequest.SpecificData.SpecificDataBuilder(outputName=" + this.outputName + ")";
            }
        }
    }
}

