/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.outputs;

import com.google.gson.JsonObject;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetOutputSettingsRequest
extends Request<SpecificData> {
    private SetOutputSettingsRequest(String outputName, JsonObject outputSettings) {
        super(RequestType.SetOutputSettings, SpecificData.builder().outputName(outputName).outputSettings(outputSettings).build());
    }

    public static SetOutputSettingsRequestBuilder builder() {
        return new SetOutputSettingsRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetOutputSettingsRequest(super=" + super.toString() + ")";
    }

    public static class SetOutputSettingsRequestBuilder {
        private String outputName;
        private JsonObject outputSettings;

        SetOutputSettingsRequestBuilder() {
        }

        public SetOutputSettingsRequestBuilder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public SetOutputSettingsRequestBuilder outputSettings(JsonObject outputSettings) {
            this.outputSettings = outputSettings;
            return this;
        }

        public SetOutputSettingsRequest build() {
            return new SetOutputSettingsRequest(this.outputName, this.outputSettings);
        }

        public String toString() {
            return "SetOutputSettingsRequest.SetOutputSettingsRequestBuilder(outputName=" + this.outputName + ", outputSettings=" + this.outputSettings + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String outputName;
        @NonNull
        private JsonObject outputSettings;

        SpecificData(@NonNull String outputName, @NonNull JsonObject outputSettings) {
            if (outputName == null) {
                throw new IllegalArgumentException("outputName is marked non-null but is null");
            }
            if (outputSettings == null) {
                throw new IllegalArgumentException("outputSettings is marked non-null but is null");
            }
            this.outputName = outputName;
            this.outputSettings = outputSettings;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getOutputName() {
            return this.outputName;
        }

        @NonNull
        public JsonObject getOutputSettings() {
            return this.outputSettings;
        }

        public String toString() {
            return "SetOutputSettingsRequest.SpecificData(outputName=" + this.getOutputName() + ", outputSettings=" + this.getOutputSettings() + ")";
        }

        public static class SpecificDataBuilder {
            private String outputName;
            private JsonObject outputSettings;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder outputName(@NonNull String outputName) {
                if (outputName == null) {
                    throw new IllegalArgumentException("outputName is marked non-null but is null");
                }
                this.outputName = outputName;
                return this;
            }

            public SpecificDataBuilder outputSettings(@NonNull JsonObject outputSettings) {
                if (outputSettings == null) {
                    throw new IllegalArgumentException("outputSettings is marked non-null but is null");
                }
                this.outputSettings = outputSettings;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.outputName, this.outputSettings);
            }

            public String toString() {
                return "SetOutputSettingsRequest.SpecificData.SpecificDataBuilder(outputName=" + this.outputName + ", outputSettings=" + this.outputSettings + ")";
            }
        }
    }
}

