/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.outputs;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class GetOutputSettingsRequest
extends Request<SpecificData> {
    private GetOutputSettingsRequest(String outputName) {
        super(RequestType.GetOutputSettings, SpecificData.builder().outputName(outputName).build());
    }

    public static GetOutputSettingsRequestBuilder builder() {
        return new GetOutputSettingsRequestBuilder();
    }

    @Override
    public String toString() {
        return "GetOutputSettingsRequest(super=" + super.toString() + ")";
    }

    public static class GetOutputSettingsRequestBuilder {
        private String outputName;

        GetOutputSettingsRequestBuilder() {
        }

        public GetOutputSettingsRequestBuilder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public GetOutputSettingsRequest build() {
            return new GetOutputSettingsRequest(this.outputName);
        }

        public String toString() {
            return "GetOutputSettingsRequest.GetOutputSettingsRequestBuilder(outputName=" + this.outputName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String outputName;

        SpecificData(@NonNull String outputName) {
            if (outputName == null) {
                throw new IllegalArgumentException("outputName is marked non-null but is null");
            }
            this.outputName = outputName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getOutputName() {
            return this.outputName;
        }

        public String toString() {
            return "GetOutputSettingsRequest.SpecificData(outputName=" + this.getOutputName() + ")";
        }

        public static class SpecificDataBuilder {
            private String outputName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder outputName(@NonNull String outputName) {
                if (outputName == null) {
                    throw new IllegalArgumentException("outputName is marked non-null but is null");
                }
                this.outputName = outputName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.outputName);
            }

            public String toString() {
                return "GetOutputSettingsRequest.SpecificData.SpecificDataBuilder(outputName=" + this.outputName + ")";
            }
        }
    }
}

