/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.mediainputs;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class TriggerMediaInputActionRequest
extends Request<SpecificData> {
    private TriggerMediaInputActionRequest(String inputName, String mediaAction) {
        super(RequestType.TriggerMediaInputAction, SpecificData.builder().inputName(inputName).mediaAction(mediaAction).build());
    }

    public static TriggerMediaInputActionRequestBuilder builder() {
        return new TriggerMediaInputActionRequestBuilder();
    }

    @Override
    public String toString() {
        return "TriggerMediaInputActionRequest(super=" + super.toString() + ")";
    }

    public static class TriggerMediaInputActionRequestBuilder {
        private String inputName;
        private String mediaAction;

        TriggerMediaInputActionRequestBuilder() {
        }

        public TriggerMediaInputActionRequestBuilder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public TriggerMediaInputActionRequestBuilder mediaAction(String mediaAction) {
            this.mediaAction = mediaAction;
            return this;
        }

        public TriggerMediaInputActionRequest build() {
            return new TriggerMediaInputActionRequest(this.inputName, this.mediaAction);
        }

        public String toString() {
            return "TriggerMediaInputActionRequest.TriggerMediaInputActionRequestBuilder(inputName=" + this.inputName + ", mediaAction=" + this.mediaAction + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String inputName;
        @NonNull
        private String mediaAction;

        SpecificData(@NonNull String inputName, @NonNull String mediaAction) {
            if (inputName == null) {
                throw new IllegalArgumentException("inputName is marked non-null but is null");
            }
            if (mediaAction == null) {
                throw new IllegalArgumentException("mediaAction is marked non-null but is null");
            }
            this.inputName = inputName;
            this.mediaAction = mediaAction;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getInputName() {
            return this.inputName;
        }

        @NonNull
        public String getMediaAction() {
            return this.mediaAction;
        }

        public String toString() {
            return "TriggerMediaInputActionRequest.SpecificData(inputName=" + this.getInputName() + ", mediaAction=" + this.getMediaAction() + ")";
        }

        public static class SpecificDataBuilder {
            private String inputName;
            private String mediaAction;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder inputName(@NonNull String inputName) {
                if (inputName == null) {
                    throw new IllegalArgumentException("inputName is marked non-null but is null");
                }
                this.inputName = inputName;
                return this;
            }

            public SpecificDataBuilder mediaAction(@NonNull String mediaAction) {
                if (mediaAction == null) {
                    throw new IllegalArgumentException("mediaAction is marked non-null but is null");
                }
                this.mediaAction = mediaAction;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.inputName, this.mediaAction);
            }

            public String toString() {
                return "TriggerMediaInputActionRequest.SpecificData.SpecificDataBuilder(inputName=" + this.inputName + ", mediaAction=" + this.mediaAction + ")";
            }
        }
    }
}

