/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.mediainputs;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetMediaInputCursorRequest
extends Request<SpecificData> {
    private SetMediaInputCursorRequest(String inputName, Number mediaCursor) {
        super(RequestType.SetMediaInputCursor, SpecificData.builder().inputName(inputName).mediaCursor(mediaCursor).build());
    }

    public static SetMediaInputCursorRequestBuilder builder() {
        return new SetMediaInputCursorRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetMediaInputCursorRequest(super=" + super.toString() + ")";
    }

    public static class SetMediaInputCursorRequestBuilder {
        private String inputName;
        private Number mediaCursor;

        SetMediaInputCursorRequestBuilder() {
        }

        public SetMediaInputCursorRequestBuilder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public SetMediaInputCursorRequestBuilder mediaCursor(Number mediaCursor) {
            this.mediaCursor = mediaCursor;
            return this;
        }

        public SetMediaInputCursorRequest build() {
            return new SetMediaInputCursorRequest(this.inputName, this.mediaCursor);
        }

        public String toString() {
            return "SetMediaInputCursorRequest.SetMediaInputCursorRequestBuilder(inputName=" + this.inputName + ", mediaCursor=" + this.mediaCursor + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String inputName;
        @NonNull
        private Number mediaCursor;

        SpecificData(@NonNull String inputName, @NonNull Number mediaCursor) {
            if (inputName == null) {
                throw new IllegalArgumentException("inputName is marked non-null but is null");
            }
            if (mediaCursor == null) {
                throw new IllegalArgumentException("mediaCursor is marked non-null but is null");
            }
            this.inputName = inputName;
            this.mediaCursor = mediaCursor;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getInputName() {
            return this.inputName;
        }

        @NonNull
        public Number getMediaCursor() {
            return this.mediaCursor;
        }

        public String toString() {
            return "SetMediaInputCursorRequest.SpecificData(inputName=" + this.getInputName() + ", mediaCursor=" + this.getMediaCursor() + ")";
        }

        public static class SpecificDataBuilder {
            private String inputName;
            private Number mediaCursor;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder inputName(@NonNull String inputName) {
                if (inputName == null) {
                    throw new IllegalArgumentException("inputName is marked non-null but is null");
                }
                this.inputName = inputName;
                return this;
            }

            public SpecificDataBuilder mediaCursor(@NonNull Number mediaCursor) {
                if (mediaCursor == null) {
                    throw new IllegalArgumentException("mediaCursor is marked non-null but is null");
                }
                this.mediaCursor = mediaCursor;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.inputName, this.mediaCursor);
            }

            public String toString() {
                return "SetMediaInputCursorRequest.SpecificData.SpecificDataBuilder(inputName=" + this.inputName + ", mediaCursor=" + this.mediaCursor + ")";
            }
        }
    }
}

