/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.mediainputs;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class OffsetMediaInputCursorRequest
extends Request<SpecificData> {
    private OffsetMediaInputCursorRequest(String inputName, Number mediaCursorOffset) {
        super(RequestType.OffsetMediaInputCursor, SpecificData.builder().inputName(inputName).mediaCursorOffset(mediaCursorOffset).build());
    }

    public static OffsetMediaInputCursorRequestBuilder builder() {
        return new OffsetMediaInputCursorRequestBuilder();
    }

    @Override
    public String toString() {
        return "OffsetMediaInputCursorRequest(super=" + super.toString() + ")";
    }

    public static class OffsetMediaInputCursorRequestBuilder {
        private String inputName;
        private Number mediaCursorOffset;

        OffsetMediaInputCursorRequestBuilder() {
        }

        public OffsetMediaInputCursorRequestBuilder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public OffsetMediaInputCursorRequestBuilder mediaCursorOffset(Number mediaCursorOffset) {
            this.mediaCursorOffset = mediaCursorOffset;
            return this;
        }

        public OffsetMediaInputCursorRequest build() {
            return new OffsetMediaInputCursorRequest(this.inputName, this.mediaCursorOffset);
        }

        public String toString() {
            return "OffsetMediaInputCursorRequest.OffsetMediaInputCursorRequestBuilder(inputName=" + this.inputName + ", mediaCursorOffset=" + this.mediaCursorOffset + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String inputName;
        @NonNull
        private Number mediaCursorOffset;

        SpecificData(@NonNull String inputName, @NonNull Number mediaCursorOffset) {
            if (inputName == null) {
                throw new IllegalArgumentException("inputName is marked non-null but is null");
            }
            if (mediaCursorOffset == null) {
                throw new IllegalArgumentException("mediaCursorOffset is marked non-null but is null");
            }
            this.inputName = inputName;
            this.mediaCursorOffset = mediaCursorOffset;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getInputName() {
            return this.inputName;
        }

        @NonNull
        public Number getMediaCursorOffset() {
            return this.mediaCursorOffset;
        }

        public String toString() {
            return "OffsetMediaInputCursorRequest.SpecificData(inputName=" + this.getInputName() + ", mediaCursorOffset=" + this.getMediaCursorOffset() + ")";
        }

        public static class SpecificDataBuilder {
            private String inputName;
            private Number mediaCursorOffset;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder inputName(@NonNull String inputName) {
                if (inputName == null) {
                    throw new IllegalArgumentException("inputName is marked non-null but is null");
                }
                this.inputName = inputName;
                return this;
            }

            public SpecificDataBuilder mediaCursorOffset(@NonNull Number mediaCursorOffset) {
                if (mediaCursorOffset == null) {
                    throw new IllegalArgumentException("mediaCursorOffset is marked non-null but is null");
                }
                this.mediaCursorOffset = mediaCursorOffset;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.inputName, this.mediaCursorOffset);
            }

            public String toString() {
                return "OffsetMediaInputCursorRequest.SpecificData.SpecificDataBuilder(inputName=" + this.inputName + ", mediaCursorOffset=" + this.mediaCursorOffset + ")";
            }
        }
    }
}

