/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.inputs;

import com.google.gson.JsonObject;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetInputSettingsRequest
extends Request<SpecificData> {
    private SetInputSettingsRequest(String inputName, JsonObject inputSettings, Boolean overlay) {
        super(RequestType.SetInputSettings, SpecificData.builder().inputName(inputName).inputSettings(inputSettings).overlay(overlay).build());
    }

    public static SetInputSettingsRequestBuilder builder() {
        return new SetInputSettingsRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetInputSettingsRequest(super=" + super.toString() + ")";
    }

    public static class SetInputSettingsRequestBuilder {
        private String inputName;
        private JsonObject inputSettings;
        private Boolean overlay;

        SetInputSettingsRequestBuilder() {
        }

        public SetInputSettingsRequestBuilder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public SetInputSettingsRequestBuilder inputSettings(JsonObject inputSettings) {
            this.inputSettings = inputSettings;
            return this;
        }

        public SetInputSettingsRequestBuilder overlay(Boolean overlay) {
            this.overlay = overlay;
            return this;
        }

        public SetInputSettingsRequest build() {
            return new SetInputSettingsRequest(this.inputName, this.inputSettings, this.overlay);
        }

        public String toString() {
            return "SetInputSettingsRequest.SetInputSettingsRequestBuilder(inputName=" + this.inputName + ", inputSettings=" + this.inputSettings + ", overlay=" + this.overlay + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String inputName;
        @NonNull
        private JsonObject inputSettings;
        private Boolean overlay;

        SpecificData(@NonNull String inputName, @NonNull JsonObject inputSettings, Boolean overlay) {
            if (inputName == null) {
                throw new IllegalArgumentException("inputName is marked non-null but is null");
            }
            if (inputSettings == null) {
                throw new IllegalArgumentException("inputSettings is marked non-null but is null");
            }
            this.inputName = inputName;
            this.inputSettings = inputSettings;
            this.overlay = overlay;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getInputName() {
            return this.inputName;
        }

        @NonNull
        public JsonObject getInputSettings() {
            return this.inputSettings;
        }

        public Boolean getOverlay() {
            return this.overlay;
        }

        public String toString() {
            return "SetInputSettingsRequest.SpecificData(inputName=" + this.getInputName() + ", inputSettings=" + this.getInputSettings() + ", overlay=" + this.getOverlay() + ")";
        }

        public static class SpecificDataBuilder {
            private String inputName;
            private JsonObject inputSettings;
            private Boolean overlay;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder inputName(@NonNull String inputName) {
                if (inputName == null) {
                    throw new IllegalArgumentException("inputName is marked non-null but is null");
                }
                this.inputName = inputName;
                return this;
            }

            public SpecificDataBuilder inputSettings(@NonNull JsonObject inputSettings) {
                if (inputSettings == null) {
                    throw new IllegalArgumentException("inputSettings is marked non-null but is null");
                }
                this.inputSettings = inputSettings;
                return this;
            }

            public SpecificDataBuilder overlay(Boolean overlay) {
                this.overlay = overlay;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.inputName, this.inputSettings, this.overlay);
            }

            public String toString() {
                return "SetInputSettingsRequest.SpecificData.SpecificDataBuilder(inputName=" + this.inputName + ", inputSettings=" + this.inputSettings + ", overlay=" + this.overlay + ")";
            }
        }
    }
}

