/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.inputs;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetInputNameRequest
extends Request<SpecificData> {
    private SetInputNameRequest(String inputName, String newInputName) {
        super(RequestType.SetInputName, SpecificData.builder().inputName(inputName).newInputName(newInputName).build());
    }

    public static SetInputNameRequestBuilder builder() {
        return new SetInputNameRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetInputNameRequest(super=" + super.toString() + ")";
    }

    public static class SetInputNameRequestBuilder {
        private String inputName;
        private String newInputName;

        SetInputNameRequestBuilder() {
        }

        public SetInputNameRequestBuilder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public SetInputNameRequestBuilder newInputName(String newInputName) {
            this.newInputName = newInputName;
            return this;
        }

        public SetInputNameRequest build() {
            return new SetInputNameRequest(this.inputName, this.newInputName);
        }

        public String toString() {
            return "SetInputNameRequest.SetInputNameRequestBuilder(inputName=" + this.inputName + ", newInputName=" + this.newInputName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String inputName;
        @NonNull
        private String newInputName;

        SpecificData(@NonNull String inputName, @NonNull String newInputName) {
            if (inputName == null) {
                throw new IllegalArgumentException("inputName is marked non-null but is null");
            }
            if (newInputName == null) {
                throw new IllegalArgumentException("newInputName is marked non-null but is null");
            }
            this.inputName = inputName;
            this.newInputName = newInputName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getInputName() {
            return this.inputName;
        }

        @NonNull
        public String getNewInputName() {
            return this.newInputName;
        }

        public String toString() {
            return "SetInputNameRequest.SpecificData(inputName=" + this.getInputName() + ", newInputName=" + this.getNewInputName() + ")";
        }

        public static class SpecificDataBuilder {
            private String inputName;
            private String newInputName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder inputName(@NonNull String inputName) {
                if (inputName == null) {
                    throw new IllegalArgumentException("inputName is marked non-null but is null");
                }
                this.inputName = inputName;
                return this;
            }

            public SpecificDataBuilder newInputName(@NonNull String newInputName) {
                if (newInputName == null) {
                    throw new IllegalArgumentException("newInputName is marked non-null but is null");
                }
                this.newInputName = newInputName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.inputName, this.newInputName);
            }

            public String toString() {
                return "SetInputNameRequest.SpecificData.SpecificDataBuilder(inputName=" + this.inputName + ", newInputName=" + this.newInputName + ")";
            }
        }
    }
}

