/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.inputs;

import com.google.gson.JsonObject;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class CreateInputRequest
extends Request<SpecificData> {
    private CreateInputRequest(String sceneName, String inputName, String inputKind, JsonObject inputSettings, Boolean sceneItemEnabled) {
        super(RequestType.CreateInput, SpecificData.builder().sceneName(sceneName).inputName(inputName).inputKind(inputKind).inputSettings(inputSettings).sceneItemEnabled(sceneItemEnabled).build());
    }

    public static CreateInputRequestBuilder builder() {
        return new CreateInputRequestBuilder();
    }

    @Override
    public String toString() {
        return "CreateInputRequest(super=" + super.toString() + ")";
    }

    public static class CreateInputRequestBuilder {
        private String sceneName;
        private String inputName;
        private String inputKind;
        private JsonObject inputSettings;
        private Boolean sceneItemEnabled;

        CreateInputRequestBuilder() {
        }

        public CreateInputRequestBuilder sceneName(String sceneName) {
            this.sceneName = sceneName;
            return this;
        }

        public CreateInputRequestBuilder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public CreateInputRequestBuilder inputKind(String inputKind) {
            this.inputKind = inputKind;
            return this;
        }

        public CreateInputRequestBuilder inputSettings(JsonObject inputSettings) {
            this.inputSettings = inputSettings;
            return this;
        }

        public CreateInputRequestBuilder sceneItemEnabled(Boolean sceneItemEnabled) {
            this.sceneItemEnabled = sceneItemEnabled;
            return this;
        }

        public CreateInputRequest build() {
            return new CreateInputRequest(this.sceneName, this.inputName, this.inputKind, this.inputSettings, this.sceneItemEnabled);
        }

        public String toString() {
            return "CreateInputRequest.CreateInputRequestBuilder(sceneName=" + this.sceneName + ", inputName=" + this.inputName + ", inputKind=" + this.inputKind + ", inputSettings=" + this.inputSettings + ", sceneItemEnabled=" + this.sceneItemEnabled + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sceneName;
        @NonNull
        private String inputName;
        @NonNull
        private String inputKind;
        private JsonObject inputSettings;
        private Boolean sceneItemEnabled;

        SpecificData(@NonNull String sceneName, @NonNull String inputName, @NonNull String inputKind, JsonObject inputSettings, Boolean sceneItemEnabled) {
            if (sceneName == null) {
                throw new IllegalArgumentException("sceneName is marked non-null but is null");
            }
            if (inputName == null) {
                throw new IllegalArgumentException("inputName is marked non-null but is null");
            }
            if (inputKind == null) {
                throw new IllegalArgumentException("inputKind is marked non-null but is null");
            }
            this.sceneName = sceneName;
            this.inputName = inputName;
            this.inputKind = inputKind;
            this.inputSettings = inputSettings;
            this.sceneItemEnabled = sceneItemEnabled;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSceneName() {
            return this.sceneName;
        }

        @NonNull
        public String getInputName() {
            return this.inputName;
        }

        @NonNull
        public String getInputKind() {
            return this.inputKind;
        }

        public JsonObject getInputSettings() {
            return this.inputSettings;
        }

        public Boolean getSceneItemEnabled() {
            return this.sceneItemEnabled;
        }

        public String toString() {
            return "CreateInputRequest.SpecificData(sceneName=" + this.getSceneName() + ", inputName=" + this.getInputName() + ", inputKind=" + this.getInputKind() + ", inputSettings=" + this.getInputSettings() + ", sceneItemEnabled=" + this.getSceneItemEnabled() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private String inputName;
            private String inputKind;
            private JsonObject inputSettings;
            private Boolean sceneItemEnabled;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(@NonNull String sceneName) {
                if (sceneName == null) {
                    throw new IllegalArgumentException("sceneName is marked non-null but is null");
                }
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder inputName(@NonNull String inputName) {
                if (inputName == null) {
                    throw new IllegalArgumentException("inputName is marked non-null but is null");
                }
                this.inputName = inputName;
                return this;
            }

            public SpecificDataBuilder inputKind(@NonNull String inputKind) {
                if (inputKind == null) {
                    throw new IllegalArgumentException("inputKind is marked non-null but is null");
                }
                this.inputKind = inputKind;
                return this;
            }

            public SpecificDataBuilder inputSettings(JsonObject inputSettings) {
                this.inputSettings = inputSettings;
                return this;
            }

            public SpecificDataBuilder sceneItemEnabled(Boolean sceneItemEnabled) {
                this.sceneItemEnabled = sceneItemEnabled;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sceneName, this.inputName, this.inputKind, this.inputSettings, this.sceneItemEnabled);
            }

            public String toString() {
                return "CreateInputRequest.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", inputName=" + this.inputName + ", inputKind=" + this.inputKind + ", inputSettings=" + this.inputSettings + ", sceneItemEnabled=" + this.sceneItemEnabled + ")";
            }
        }
    }
}

