/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.general;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;

public class SleepRequest
extends Request<SpecificData> {
    private SleepRequest(Number sleepMillis, Number sleepFrames) {
        super(RequestType.Sleep, SpecificData.builder().sleepMillis(sleepMillis).sleepFrames(sleepFrames).build());
    }

    public static SleepRequestBuilder builder() {
        return new SleepRequestBuilder();
    }

    @Override
    public String toString() {
        return "SleepRequest(super=" + super.toString() + ")";
    }

    public static class SleepRequestBuilder {
        private Number sleepMillis;
        private Number sleepFrames;

        SleepRequestBuilder() {
        }

        public SleepRequestBuilder sleepMillis(Number sleepMillis) {
            this.sleepMillis = sleepMillis;
            return this;
        }

        public SleepRequestBuilder sleepFrames(Number sleepFrames) {
            this.sleepFrames = sleepFrames;
            return this;
        }

        public SleepRequest build() {
            return new SleepRequest(this.sleepMillis, this.sleepFrames);
        }

        public String toString() {
            return "SleepRequest.SleepRequestBuilder(sleepMillis=" + this.sleepMillis + ", sleepFrames=" + this.sleepFrames + ")";
        }
    }

    static class SpecificData {
        private Number sleepMillis;
        private Number sleepFrames;

        SpecificData(Number sleepMillis, Number sleepFrames) {
            this.sleepMillis = sleepMillis;
            this.sleepFrames = sleepFrames;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public Number getSleepMillis() {
            return this.sleepMillis;
        }

        public Number getSleepFrames() {
            return this.sleepFrames;
        }

        public String toString() {
            return "SleepRequest.SpecificData(sleepMillis=" + this.getSleepMillis() + ", sleepFrames=" + this.getSleepFrames() + ")";
        }

        public static class SpecificDataBuilder {
            private Number sleepMillis;
            private Number sleepFrames;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sleepMillis(Number sleepMillis) {
                this.sleepMillis = sleepMillis;
                return this;
            }

            public SpecificDataBuilder sleepFrames(Number sleepFrames) {
                this.sleepFrames = sleepFrames;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sleepMillis, this.sleepFrames);
            }

            public String toString() {
                return "SleepRequest.SpecificData.SpecificDataBuilder(sleepMillis=" + this.sleepMillis + ", sleepFrames=" + this.sleepFrames + ")";
            }
        }
    }
}

