/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.general;

import com.google.gson.JsonObject;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class CallVendorRequestRequest
extends Request<SpecificData> {
    private CallVendorRequestRequest(String vendorName, String requestType, JsonObject requestData) {
        super(RequestType.CallVendorRequest, SpecificData.builder().vendorName(vendorName).requestType(requestType).requestData(requestData).build());
    }

    public static CallVendorRequestRequestBuilder builder() {
        return new CallVendorRequestRequestBuilder();
    }

    @Override
    public String toString() {
        return "CallVendorRequestRequest(super=" + super.toString() + ")";
    }

    public static class CallVendorRequestRequestBuilder {
        private String vendorName;
        private String requestType;
        private JsonObject requestData;

        CallVendorRequestRequestBuilder() {
        }

        public CallVendorRequestRequestBuilder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public CallVendorRequestRequestBuilder requestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        public CallVendorRequestRequestBuilder requestData(JsonObject requestData) {
            this.requestData = requestData;
            return this;
        }

        public CallVendorRequestRequest build() {
            return new CallVendorRequestRequest(this.vendorName, this.requestType, this.requestData);
        }

        public String toString() {
            return "CallVendorRequestRequest.CallVendorRequestRequestBuilder(vendorName=" + this.vendorName + ", requestType=" + this.requestType + ", requestData=" + this.requestData + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String vendorName;
        @NonNull
        private String requestType;
        private JsonObject requestData;

        SpecificData(@NonNull String vendorName, @NonNull String requestType, JsonObject requestData) {
            if (vendorName == null) {
                throw new IllegalArgumentException("vendorName is marked non-null but is null");
            }
            if (requestType == null) {
                throw new IllegalArgumentException("requestType is marked non-null but is null");
            }
            this.vendorName = vendorName;
            this.requestType = requestType;
            this.requestData = requestData;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getVendorName() {
            return this.vendorName;
        }

        @NonNull
        public String getRequestType() {
            return this.requestType;
        }

        public JsonObject getRequestData() {
            return this.requestData;
        }

        public String toString() {
            return "CallVendorRequestRequest.SpecificData(vendorName=" + this.getVendorName() + ", requestType=" + this.getRequestType() + ", requestData=" + this.getRequestData() + ")";
        }

        public static class SpecificDataBuilder {
            private String vendorName;
            private String requestType;
            private JsonObject requestData;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder vendorName(@NonNull String vendorName) {
                if (vendorName == null) {
                    throw new IllegalArgumentException("vendorName is marked non-null but is null");
                }
                this.vendorName = vendorName;
                return this;
            }

            public SpecificDataBuilder requestType(@NonNull String requestType) {
                if (requestType == null) {
                    throw new IllegalArgumentException("requestType is marked non-null but is null");
                }
                this.requestType = requestType;
                return this;
            }

            public SpecificDataBuilder requestData(JsonObject requestData) {
                this.requestData = requestData;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.vendorName, this.requestType, this.requestData);
            }

            public String toString() {
                return "CallVendorRequestRequest.SpecificData.SpecificDataBuilder(vendorName=" + this.vendorName + ", requestType=" + this.requestType + ", requestData=" + this.requestData + ")";
            }
        }
    }
}

