/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.general;

import com.google.gson.JsonObject;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class BroadcastCustomEventRequest
extends Request<SpecificData> {
    private BroadcastCustomEventRequest(JsonObject eventData) {
        super(RequestType.BroadcastCustomEvent, SpecificData.builder().eventData(eventData).build());
    }

    public static BroadcastCustomEventRequestBuilder builder() {
        return new BroadcastCustomEventRequestBuilder();
    }

    @Override
    public String toString() {
        return "BroadcastCustomEventRequest(super=" + super.toString() + ")";
    }

    public static class BroadcastCustomEventRequestBuilder {
        private JsonObject eventData;

        BroadcastCustomEventRequestBuilder() {
        }

        public BroadcastCustomEventRequestBuilder eventData(JsonObject eventData) {
            this.eventData = eventData;
            return this;
        }

        public BroadcastCustomEventRequest build() {
            return new BroadcastCustomEventRequest(this.eventData);
        }

        public String toString() {
            return "BroadcastCustomEventRequest.BroadcastCustomEventRequestBuilder(eventData=" + this.eventData + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private JsonObject eventData;

        SpecificData(@NonNull JsonObject eventData) {
            if (eventData == null) {
                throw new IllegalArgumentException("eventData is marked non-null but is null");
            }
            this.eventData = eventData;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public JsonObject getEventData() {
            return this.eventData;
        }

        public String toString() {
            return "BroadcastCustomEventRequest.SpecificData(eventData=" + this.getEventData() + ")";
        }

        public static class SpecificDataBuilder {
            private JsonObject eventData;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder eventData(@NonNull JsonObject eventData) {
                if (eventData == null) {
                    throw new IllegalArgumentException("eventData is marked non-null but is null");
                }
                this.eventData = eventData;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.eventData);
            }

            public String toString() {
                return "BroadcastCustomEventRequest.SpecificData.SpecificDataBuilder(eventData=" + this.eventData + ")";
            }
        }
    }
}

