/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.filters;

import com.google.gson.JsonObject;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetSourceFilterSettingsRequest
extends Request<SpecificData> {
    private SetSourceFilterSettingsRequest(String sourceName, String filterName, JsonObject filterSettings, Boolean overlay) {
        super(RequestType.SetSourceFilterSettings, SpecificData.builder().sourceName(sourceName).filterName(filterName).filterSettings(filterSettings).overlay(overlay).build());
    }

    public static SetSourceFilterSettingsRequestBuilder builder() {
        return new SetSourceFilterSettingsRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetSourceFilterSettingsRequest(super=" + super.toString() + ")";
    }

    public static class SetSourceFilterSettingsRequestBuilder {
        private String sourceName;
        private String filterName;
        private JsonObject filterSettings;
        private Boolean overlay;

        SetSourceFilterSettingsRequestBuilder() {
        }

        public SetSourceFilterSettingsRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public SetSourceFilterSettingsRequestBuilder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public SetSourceFilterSettingsRequestBuilder filterSettings(JsonObject filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public SetSourceFilterSettingsRequestBuilder overlay(Boolean overlay) {
            this.overlay = overlay;
            return this;
        }

        public SetSourceFilterSettingsRequest build() {
            return new SetSourceFilterSettingsRequest(this.sourceName, this.filterName, this.filterSettings, this.overlay);
        }

        public String toString() {
            return "SetSourceFilterSettingsRequest.SetSourceFilterSettingsRequestBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", filterSettings=" + this.filterSettings + ", overlay=" + this.overlay + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sourceName;
        @NonNull
        private String filterName;
        @NonNull
        private JsonObject filterSettings;
        private Boolean overlay;

        SpecificData(@NonNull String sourceName, @NonNull String filterName, @NonNull JsonObject filterSettings, Boolean overlay) {
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            if (filterName == null) {
                throw new IllegalArgumentException("filterName is marked non-null but is null");
            }
            if (filterSettings == null) {
                throw new IllegalArgumentException("filterSettings is marked non-null but is null");
            }
            this.sourceName = sourceName;
            this.filterName = filterName;
            this.filterSettings = filterSettings;
            this.overlay = overlay;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        @NonNull
        public String getFilterName() {
            return this.filterName;
        }

        @NonNull
        public JsonObject getFilterSettings() {
            return this.filterSettings;
        }

        public Boolean getOverlay() {
            return this.overlay;
        }

        public String toString() {
            return "SetSourceFilterSettingsRequest.SpecificData(sourceName=" + this.getSourceName() + ", filterName=" + this.getFilterName() + ", filterSettings=" + this.getFilterSettings() + ", overlay=" + this.getOverlay() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private String filterName;
            private JsonObject filterSettings;
            private Boolean overlay;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder filterName(@NonNull String filterName) {
                if (filterName == null) {
                    throw new IllegalArgumentException("filterName is marked non-null but is null");
                }
                this.filterName = filterName;
                return this;
            }

            public SpecificDataBuilder filterSettings(@NonNull JsonObject filterSettings) {
                if (filterSettings == null) {
                    throw new IllegalArgumentException("filterSettings is marked non-null but is null");
                }
                this.filterSettings = filterSettings;
                return this;
            }

            public SpecificDataBuilder overlay(Boolean overlay) {
                this.overlay = overlay;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.filterName, this.filterSettings, this.overlay);
            }

            public String toString() {
                return "SetSourceFilterSettingsRequest.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", filterSettings=" + this.filterSettings + ", overlay=" + this.overlay + ")";
            }
        }
    }
}

