/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.filters;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetSourceFilterNameRequest
extends Request<SpecificData> {
    private SetSourceFilterNameRequest(String sourceName, String filterName, String newFilterName) {
        super(RequestType.SetSourceFilterName, SpecificData.builder().sourceName(sourceName).filterName(filterName).newFilterName(newFilterName).build());
    }

    public static SetSourceFilterNameRequestBuilder builder() {
        return new SetSourceFilterNameRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetSourceFilterNameRequest(super=" + super.toString() + ")";
    }

    public static class SetSourceFilterNameRequestBuilder {
        private String sourceName;
        private String filterName;
        private String newFilterName;

        SetSourceFilterNameRequestBuilder() {
        }

        public SetSourceFilterNameRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public SetSourceFilterNameRequestBuilder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public SetSourceFilterNameRequestBuilder newFilterName(String newFilterName) {
            this.newFilterName = newFilterName;
            return this;
        }

        public SetSourceFilterNameRequest build() {
            return new SetSourceFilterNameRequest(this.sourceName, this.filterName, this.newFilterName);
        }

        public String toString() {
            return "SetSourceFilterNameRequest.SetSourceFilterNameRequestBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", newFilterName=" + this.newFilterName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sourceName;
        @NonNull
        private String filterName;
        @NonNull
        private String newFilterName;

        SpecificData(@NonNull String sourceName, @NonNull String filterName, @NonNull String newFilterName) {
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            if (filterName == null) {
                throw new IllegalArgumentException("filterName is marked non-null but is null");
            }
            if (newFilterName == null) {
                throw new IllegalArgumentException("newFilterName is marked non-null but is null");
            }
            this.sourceName = sourceName;
            this.filterName = filterName;
            this.newFilterName = newFilterName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        @NonNull
        public String getFilterName() {
            return this.filterName;
        }

        @NonNull
        public String getNewFilterName() {
            return this.newFilterName;
        }

        public String toString() {
            return "SetSourceFilterNameRequest.SpecificData(sourceName=" + this.getSourceName() + ", filterName=" + this.getFilterName() + ", newFilterName=" + this.getNewFilterName() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private String filterName;
            private String newFilterName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder filterName(@NonNull String filterName) {
                if (filterName == null) {
                    throw new IllegalArgumentException("filterName is marked non-null but is null");
                }
                this.filterName = filterName;
                return this;
            }

            public SpecificDataBuilder newFilterName(@NonNull String newFilterName) {
                if (newFilterName == null) {
                    throw new IllegalArgumentException("newFilterName is marked non-null but is null");
                }
                this.newFilterName = newFilterName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.filterName, this.newFilterName);
            }

            public String toString() {
                return "SetSourceFilterNameRequest.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", newFilterName=" + this.newFilterName + ")";
            }
        }
    }
}

