/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.filters;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetSourceFilterIndexRequest
extends Request<SpecificData> {
    private SetSourceFilterIndexRequest(String sourceName, String filterName, Number filterIndex) {
        super(RequestType.SetSourceFilterIndex, SpecificData.builder().sourceName(sourceName).filterName(filterName).filterIndex(filterIndex).build());
    }

    public static SetSourceFilterIndexRequestBuilder builder() {
        return new SetSourceFilterIndexRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetSourceFilterIndexRequest(super=" + super.toString() + ")";
    }

    public static class SetSourceFilterIndexRequestBuilder {
        private String sourceName;
        private String filterName;
        private Number filterIndex;

        SetSourceFilterIndexRequestBuilder() {
        }

        public SetSourceFilterIndexRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public SetSourceFilterIndexRequestBuilder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public SetSourceFilterIndexRequestBuilder filterIndex(Number filterIndex) {
            this.filterIndex = filterIndex;
            return this;
        }

        public SetSourceFilterIndexRequest build() {
            return new SetSourceFilterIndexRequest(this.sourceName, this.filterName, this.filterIndex);
        }

        public String toString() {
            return "SetSourceFilterIndexRequest.SetSourceFilterIndexRequestBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", filterIndex=" + this.filterIndex + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sourceName;
        @NonNull
        private String filterName;
        @NonNull
        private Number filterIndex;

        SpecificData(@NonNull String sourceName, @NonNull String filterName, @NonNull Number filterIndex) {
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            if (filterName == null) {
                throw new IllegalArgumentException("filterName is marked non-null but is null");
            }
            if (filterIndex == null) {
                throw new IllegalArgumentException("filterIndex is marked non-null but is null");
            }
            this.sourceName = sourceName;
            this.filterName = filterName;
            this.filterIndex = filterIndex;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        @NonNull
        public String getFilterName() {
            return this.filterName;
        }

        @NonNull
        public Number getFilterIndex() {
            return this.filterIndex;
        }

        public String toString() {
            return "SetSourceFilterIndexRequest.SpecificData(sourceName=" + this.getSourceName() + ", filterName=" + this.getFilterName() + ", filterIndex=" + this.getFilterIndex() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private String filterName;
            private Number filterIndex;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder filterName(@NonNull String filterName) {
                if (filterName == null) {
                    throw new IllegalArgumentException("filterName is marked non-null but is null");
                }
                this.filterName = filterName;
                return this;
            }

            public SpecificDataBuilder filterIndex(@NonNull Number filterIndex) {
                if (filterIndex == null) {
                    throw new IllegalArgumentException("filterIndex is marked non-null but is null");
                }
                this.filterIndex = filterIndex;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.filterName, this.filterIndex);
            }

            public String toString() {
                return "SetSourceFilterIndexRequest.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", filterIndex=" + this.filterIndex + ")";
            }
        }
    }
}

