/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.filters;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetSourceFilterEnabledRequest
extends Request<SpecificData> {
    private SetSourceFilterEnabledRequest(String sourceName, String filterName, Boolean filterEnabled) {
        super(RequestType.SetSourceFilterEnabled, SpecificData.builder().sourceName(sourceName).filterName(filterName).filterEnabled(filterEnabled).build());
    }

    public static SetSourceFilterEnabledRequestBuilder builder() {
        return new SetSourceFilterEnabledRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetSourceFilterEnabledRequest(super=" + super.toString() + ")";
    }

    public static class SetSourceFilterEnabledRequestBuilder {
        private String sourceName;
        private String filterName;
        private Boolean filterEnabled;

        SetSourceFilterEnabledRequestBuilder() {
        }

        public SetSourceFilterEnabledRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public SetSourceFilterEnabledRequestBuilder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public SetSourceFilterEnabledRequestBuilder filterEnabled(Boolean filterEnabled) {
            this.filterEnabled = filterEnabled;
            return this;
        }

        public SetSourceFilterEnabledRequest build() {
            return new SetSourceFilterEnabledRequest(this.sourceName, this.filterName, this.filterEnabled);
        }

        public String toString() {
            return "SetSourceFilterEnabledRequest.SetSourceFilterEnabledRequestBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", filterEnabled=" + this.filterEnabled + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sourceName;
        @NonNull
        private String filterName;
        @NonNull
        private Boolean filterEnabled;

        SpecificData(@NonNull String sourceName, @NonNull String filterName, @NonNull Boolean filterEnabled) {
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            if (filterName == null) {
                throw new IllegalArgumentException("filterName is marked non-null but is null");
            }
            if (filterEnabled == null) {
                throw new IllegalArgumentException("filterEnabled is marked non-null but is null");
            }
            this.sourceName = sourceName;
            this.filterName = filterName;
            this.filterEnabled = filterEnabled;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        @NonNull
        public String getFilterName() {
            return this.filterName;
        }

        @NonNull
        public Boolean getFilterEnabled() {
            return this.filterEnabled;
        }

        public String toString() {
            return "SetSourceFilterEnabledRequest.SpecificData(sourceName=" + this.getSourceName() + ", filterName=" + this.getFilterName() + ", filterEnabled=" + this.getFilterEnabled() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private String filterName;
            private Boolean filterEnabled;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder filterName(@NonNull String filterName) {
                if (filterName == null) {
                    throw new IllegalArgumentException("filterName is marked non-null but is null");
                }
                this.filterName = filterName;
                return this;
            }

            public SpecificDataBuilder filterEnabled(@NonNull Boolean filterEnabled) {
                if (filterEnabled == null) {
                    throw new IllegalArgumentException("filterEnabled is marked non-null but is null");
                }
                this.filterEnabled = filterEnabled;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.filterName, this.filterEnabled);
            }

            public String toString() {
                return "SetSourceFilterEnabledRequest.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", filterEnabled=" + this.filterEnabled + ")";
            }
        }
    }
}

