/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.filters;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class RemoveSourceFilterRequest
extends Request<SpecificData> {
    private RemoveSourceFilterRequest(String sourceName, String filterName) {
        super(RequestType.RemoveSourceFilter, SpecificData.builder().sourceName(sourceName).filterName(filterName).build());
    }

    public static RemoveSourceFilterRequestBuilder builder() {
        return new RemoveSourceFilterRequestBuilder();
    }

    @Override
    public String toString() {
        return "RemoveSourceFilterRequest(super=" + super.toString() + ")";
    }

    public static class RemoveSourceFilterRequestBuilder {
        private String sourceName;
        private String filterName;

        RemoveSourceFilterRequestBuilder() {
        }

        public RemoveSourceFilterRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public RemoveSourceFilterRequestBuilder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public RemoveSourceFilterRequest build() {
            return new RemoveSourceFilterRequest(this.sourceName, this.filterName);
        }

        public String toString() {
            return "RemoveSourceFilterRequest.RemoveSourceFilterRequestBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sourceName;
        @NonNull
        private String filterName;

        SpecificData(@NonNull String sourceName, @NonNull String filterName) {
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            if (filterName == null) {
                throw new IllegalArgumentException("filterName is marked non-null but is null");
            }
            this.sourceName = sourceName;
            this.filterName = filterName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        @NonNull
        public String getFilterName() {
            return this.filterName;
        }

        public String toString() {
            return "RemoveSourceFilterRequest.SpecificData(sourceName=" + this.getSourceName() + ", filterName=" + this.getFilterName() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private String filterName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder filterName(@NonNull String filterName) {
                if (filterName == null) {
                    throw new IllegalArgumentException("filterName is marked non-null but is null");
                }
                this.filterName = filterName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.filterName);
            }

            public String toString() {
                return "RemoveSourceFilterRequest.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ")";
            }
        }
    }
}

