/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.filters;

import com.google.gson.JsonObject;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class CreateSourceFilterRequest
extends Request<SpecificData> {
    private CreateSourceFilterRequest(String sourceName, String filterName, String filterKind, JsonObject filterSettings) {
        super(RequestType.CreateSourceFilter, SpecificData.builder().sourceName(sourceName).filterName(filterName).filterKind(filterKind).filterSettings(filterSettings).build());
    }

    public static CreateSourceFilterRequestBuilder builder() {
        return new CreateSourceFilterRequestBuilder();
    }

    @Override
    public String toString() {
        return "CreateSourceFilterRequest(super=" + super.toString() + ")";
    }

    public static class CreateSourceFilterRequestBuilder {
        private String sourceName;
        private String filterName;
        private String filterKind;
        private JsonObject filterSettings;

        CreateSourceFilterRequestBuilder() {
        }

        public CreateSourceFilterRequestBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public CreateSourceFilterRequestBuilder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public CreateSourceFilterRequestBuilder filterKind(String filterKind) {
            this.filterKind = filterKind;
            return this;
        }

        public CreateSourceFilterRequestBuilder filterSettings(JsonObject filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public CreateSourceFilterRequest build() {
            return new CreateSourceFilterRequest(this.sourceName, this.filterName, this.filterKind, this.filterSettings);
        }

        public String toString() {
            return "CreateSourceFilterRequest.CreateSourceFilterRequestBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", filterKind=" + this.filterKind + ", filterSettings=" + this.filterSettings + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String sourceName;
        @NonNull
        private String filterName;
        @NonNull
        private String filterKind;
        private JsonObject filterSettings;

        SpecificData(@NonNull String sourceName, @NonNull String filterName, @NonNull String filterKind, JsonObject filterSettings) {
            if (sourceName == null) {
                throw new IllegalArgumentException("sourceName is marked non-null but is null");
            }
            if (filterName == null) {
                throw new IllegalArgumentException("filterName is marked non-null but is null");
            }
            if (filterKind == null) {
                throw new IllegalArgumentException("filterKind is marked non-null but is null");
            }
            this.sourceName = sourceName;
            this.filterName = filterName;
            this.filterKind = filterKind;
            this.filterSettings = filterSettings;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getSourceName() {
            return this.sourceName;
        }

        @NonNull
        public String getFilterName() {
            return this.filterName;
        }

        @NonNull
        public String getFilterKind() {
            return this.filterKind;
        }

        public JsonObject getFilterSettings() {
            return this.filterSettings;
        }

        public String toString() {
            return "CreateSourceFilterRequest.SpecificData(sourceName=" + this.getSourceName() + ", filterName=" + this.getFilterName() + ", filterKind=" + this.getFilterKind() + ", filterSettings=" + this.getFilterSettings() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private String filterName;
            private String filterKind;
            private JsonObject filterSettings;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(@NonNull String sourceName) {
                if (sourceName == null) {
                    throw new IllegalArgumentException("sourceName is marked non-null but is null");
                }
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder filterName(@NonNull String filterName) {
                if (filterName == null) {
                    throw new IllegalArgumentException("filterName is marked non-null but is null");
                }
                this.filterName = filterName;
                return this;
            }

            public SpecificDataBuilder filterKind(@NonNull String filterKind) {
                if (filterKind == null) {
                    throw new IllegalArgumentException("filterKind is marked non-null but is null");
                }
                this.filterKind = filterKind;
                return this;
            }

            public SpecificDataBuilder filterSettings(JsonObject filterSettings) {
                this.filterSettings = filterSettings;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.filterName, this.filterKind, this.filterSettings);
            }

            public String toString() {
                return "CreateSourceFilterRequest.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", filterName=" + this.filterName + ", filterKind=" + this.filterKind + ", filterSettings=" + this.filterSettings + ")";
            }
        }
    }
}

