/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.config;

import com.google.gson.JsonObject;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class SetStreamServiceSettingsRequest
extends Request<SpecificData> {
    private SetStreamServiceSettingsRequest(String streamServiceType, JsonObject streamServiceSettings) {
        super(RequestType.SetStreamServiceSettings, SpecificData.builder().streamServiceType(streamServiceType).streamServiceSettings(streamServiceSettings).build());
    }

    public static SetStreamServiceSettingsRequestBuilder builder() {
        return new SetStreamServiceSettingsRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetStreamServiceSettingsRequest(super=" + super.toString() + ")";
    }

    public static class SetStreamServiceSettingsRequestBuilder {
        private String streamServiceType;
        private JsonObject streamServiceSettings;

        SetStreamServiceSettingsRequestBuilder() {
        }

        public SetStreamServiceSettingsRequestBuilder streamServiceType(String streamServiceType) {
            this.streamServiceType = streamServiceType;
            return this;
        }

        public SetStreamServiceSettingsRequestBuilder streamServiceSettings(JsonObject streamServiceSettings) {
            this.streamServiceSettings = streamServiceSettings;
            return this;
        }

        public SetStreamServiceSettingsRequest build() {
            return new SetStreamServiceSettingsRequest(this.streamServiceType, this.streamServiceSettings);
        }

        public String toString() {
            return "SetStreamServiceSettingsRequest.SetStreamServiceSettingsRequestBuilder(streamServiceType=" + this.streamServiceType + ", streamServiceSettings=" + this.streamServiceSettings + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String streamServiceType;
        @NonNull
        private JsonObject streamServiceSettings;

        SpecificData(@NonNull String streamServiceType, @NonNull JsonObject streamServiceSettings) {
            if (streamServiceType == null) {
                throw new IllegalArgumentException("streamServiceType is marked non-null but is null");
            }
            if (streamServiceSettings == null) {
                throw new IllegalArgumentException("streamServiceSettings is marked non-null but is null");
            }
            this.streamServiceType = streamServiceType;
            this.streamServiceSettings = streamServiceSettings;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getStreamServiceType() {
            return this.streamServiceType;
        }

        @NonNull
        public JsonObject getStreamServiceSettings() {
            return this.streamServiceSettings;
        }

        public String toString() {
            return "SetStreamServiceSettingsRequest.SpecificData(streamServiceType=" + this.getStreamServiceType() + ", streamServiceSettings=" + this.getStreamServiceSettings() + ")";
        }

        public static class SpecificDataBuilder {
            private String streamServiceType;
            private JsonObject streamServiceSettings;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder streamServiceType(@NonNull String streamServiceType) {
                if (streamServiceType == null) {
                    throw new IllegalArgumentException("streamServiceType is marked non-null but is null");
                }
                this.streamServiceType = streamServiceType;
                return this;
            }

            public SpecificDataBuilder streamServiceSettings(@NonNull JsonObject streamServiceSettings) {
                if (streamServiceSettings == null) {
                    throw new IllegalArgumentException("streamServiceSettings is marked non-null but is null");
                }
                this.streamServiceSettings = streamServiceSettings;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.streamServiceType, this.streamServiceSettings);
            }

            public String toString() {
                return "SetStreamServiceSettingsRequest.SpecificData.SpecificDataBuilder(streamServiceType=" + this.streamServiceType + ", streamServiceSettings=" + this.streamServiceSettings + ")";
            }
        }
    }
}

