/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.config;

import com.google.gson.JsonElement;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import io.obswebsocket.community.client.model.Realm;
import lombok.NonNull;

public class SetPersistentDataRequest
extends Request<SpecificData> {
    private SetPersistentDataRequest(Realm realm, String slotName, JsonElement slotValue) {
        super(RequestType.SetPersistentData, SpecificData.builder().realm(realm).slotName(slotName).slotValue(slotValue).build());
    }

    public static SetPersistentDataRequestBuilder builder() {
        return new SetPersistentDataRequestBuilder();
    }

    @Override
    public String toString() {
        return "SetPersistentDataRequest(super=" + super.toString() + ")";
    }

    public static class SetPersistentDataRequestBuilder {
        private Realm realm;
        private String slotName;
        private JsonElement slotValue;

        SetPersistentDataRequestBuilder() {
        }

        public SetPersistentDataRequestBuilder realm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public SetPersistentDataRequestBuilder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public SetPersistentDataRequestBuilder slotValue(JsonElement slotValue) {
            this.slotValue = slotValue;
            return this;
        }

        public SetPersistentDataRequest build() {
            return new SetPersistentDataRequest(this.realm, this.slotName, this.slotValue);
        }

        public String toString() {
            return "SetPersistentDataRequest.SetPersistentDataRequestBuilder(realm=" + (Object)((Object)this.realm) + ", slotName=" + this.slotName + ", slotValue=" + this.slotValue + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private Realm realm;
        @NonNull
        private String slotName;
        @NonNull
        private JsonElement slotValue;

        SpecificData(@NonNull Realm realm, @NonNull String slotName, @NonNull JsonElement slotValue) {
            if (realm == null) {
                throw new IllegalArgumentException("realm is marked non-null but is null");
            }
            if (slotName == null) {
                throw new IllegalArgumentException("slotName is marked non-null but is null");
            }
            if (slotValue == null) {
                throw new IllegalArgumentException("slotValue is marked non-null but is null");
            }
            this.realm = realm;
            this.slotName = slotName;
            this.slotValue = slotValue;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public Realm getRealm() {
            return this.realm;
        }

        @NonNull
        public String getSlotName() {
            return this.slotName;
        }

        @NonNull
        public JsonElement getSlotValue() {
            return this.slotValue;
        }

        public String toString() {
            return "SetPersistentDataRequest.SpecificData(realm=" + (Object)((Object)this.getRealm()) + ", slotName=" + this.getSlotName() + ", slotValue=" + this.getSlotValue() + ")";
        }

        public static class SpecificDataBuilder {
            private Realm realm;
            private String slotName;
            private JsonElement slotValue;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder realm(@NonNull Realm realm) {
                if (realm == null) {
                    throw new IllegalArgumentException("realm is marked non-null but is null");
                }
                this.realm = realm;
                return this;
            }

            public SpecificDataBuilder slotName(@NonNull String slotName) {
                if (slotName == null) {
                    throw new IllegalArgumentException("slotName is marked non-null but is null");
                }
                this.slotName = slotName;
                return this;
            }

            public SpecificDataBuilder slotValue(@NonNull JsonElement slotValue) {
                if (slotValue == null) {
                    throw new IllegalArgumentException("slotValue is marked non-null but is null");
                }
                this.slotValue = slotValue;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.realm, this.slotName, this.slotValue);
            }

            public String toString() {
                return "SetPersistentDataRequest.SpecificData.SpecificDataBuilder(realm=" + (Object)((Object)this.realm) + ", slotName=" + this.slotName + ", slotValue=" + this.slotValue + ")";
            }
        }
    }
}

