/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.config;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class RemoveProfileRequest
extends Request<SpecificData> {
    private RemoveProfileRequest(String profileName) {
        super(RequestType.RemoveProfile, SpecificData.builder().profileName(profileName).build());
    }

    public static RemoveProfileRequestBuilder builder() {
        return new RemoveProfileRequestBuilder();
    }

    @Override
    public String toString() {
        return "RemoveProfileRequest(super=" + super.toString() + ")";
    }

    public static class RemoveProfileRequestBuilder {
        private String profileName;

        RemoveProfileRequestBuilder() {
        }

        public RemoveProfileRequestBuilder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public RemoveProfileRequest build() {
            return new RemoveProfileRequest(this.profileName);
        }

        public String toString() {
            return "RemoveProfileRequest.RemoveProfileRequestBuilder(profileName=" + this.profileName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String profileName;

        SpecificData(@NonNull String profileName) {
            if (profileName == null) {
                throw new IllegalArgumentException("profileName is marked non-null but is null");
            }
            this.profileName = profileName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getProfileName() {
            return this.profileName;
        }

        public String toString() {
            return "RemoveProfileRequest.SpecificData(profileName=" + this.getProfileName() + ")";
        }

        public static class SpecificDataBuilder {
            private String profileName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder profileName(@NonNull String profileName) {
                if (profileName == null) {
                    throw new IllegalArgumentException("profileName is marked non-null but is null");
                }
                this.profileName = profileName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.profileName);
            }

            public String toString() {
                return "RemoveProfileRequest.SpecificData.SpecificDataBuilder(profileName=" + this.profileName + ")";
            }
        }
    }
}

