/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.config;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import io.obswebsocket.community.client.model.Realm;
import lombok.NonNull;

public class GetPersistentDataRequest
extends Request<SpecificData> {
    private GetPersistentDataRequest(Realm realm, String slotName) {
        super(RequestType.GetPersistentData, SpecificData.builder().realm(realm).slotName(slotName).build());
    }

    public static GetPersistentDataRequestBuilder builder() {
        return new GetPersistentDataRequestBuilder();
    }

    @Override
    public String toString() {
        return "GetPersistentDataRequest(super=" + super.toString() + ")";
    }

    public static class GetPersistentDataRequestBuilder {
        private Realm realm;
        private String slotName;

        GetPersistentDataRequestBuilder() {
        }

        public GetPersistentDataRequestBuilder realm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public GetPersistentDataRequestBuilder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public GetPersistentDataRequest build() {
            return new GetPersistentDataRequest(this.realm, this.slotName);
        }

        public String toString() {
            return "GetPersistentDataRequest.GetPersistentDataRequestBuilder(realm=" + (Object)((Object)this.realm) + ", slotName=" + this.slotName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private Realm realm;
        @NonNull
        private String slotName;

        SpecificData(@NonNull Realm realm, @NonNull String slotName) {
            if (realm == null) {
                throw new IllegalArgumentException("realm is marked non-null but is null");
            }
            if (slotName == null) {
                throw new IllegalArgumentException("slotName is marked non-null but is null");
            }
            this.realm = realm;
            this.slotName = slotName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public Realm getRealm() {
            return this.realm;
        }

        @NonNull
        public String getSlotName() {
            return this.slotName;
        }

        public String toString() {
            return "GetPersistentDataRequest.SpecificData(realm=" + (Object)((Object)this.getRealm()) + ", slotName=" + this.getSlotName() + ")";
        }

        public static class SpecificDataBuilder {
            private Realm realm;
            private String slotName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder realm(@NonNull Realm realm) {
                if (realm == null) {
                    throw new IllegalArgumentException("realm is marked non-null but is null");
                }
                this.realm = realm;
                return this;
            }

            public SpecificDataBuilder slotName(@NonNull String slotName) {
                if (slotName == null) {
                    throw new IllegalArgumentException("slotName is marked non-null but is null");
                }
                this.slotName = slotName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.realm, this.slotName);
            }

            public String toString() {
                return "GetPersistentDataRequest.SpecificData.SpecificDataBuilder(realm=" + (Object)((Object)this.realm) + ", slotName=" + this.slotName + ")";
            }
        }
    }
}

