/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request.config;

import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestType;
import lombok.NonNull;

public class CreateProfileRequest
extends Request<SpecificData> {
    private CreateProfileRequest(String profileName) {
        super(RequestType.CreateProfile, SpecificData.builder().profileName(profileName).build());
    }

    public static CreateProfileRequestBuilder builder() {
        return new CreateProfileRequestBuilder();
    }

    @Override
    public String toString() {
        return "CreateProfileRequest(super=" + super.toString() + ")";
    }

    public static class CreateProfileRequestBuilder {
        private String profileName;

        CreateProfileRequestBuilder() {
        }

        public CreateProfileRequestBuilder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public CreateProfileRequest build() {
            return new CreateProfileRequest(this.profileName);
        }

        public String toString() {
            return "CreateProfileRequest.CreateProfileRequestBuilder(profileName=" + this.profileName + ")";
        }
    }

    static class SpecificData {
        @NonNull
        private String profileName;

        SpecificData(@NonNull String profileName) {
            if (profileName == null) {
                throw new IllegalArgumentException("profileName is marked non-null but is null");
            }
            this.profileName = profileName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        @NonNull
        public String getProfileName() {
            return this.profileName;
        }

        public String toString() {
            return "CreateProfileRequest.SpecificData(profileName=" + this.getProfileName() + ")";
        }

        public static class SpecificDataBuilder {
            private String profileName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder profileName(@NonNull String profileName) {
                if (profileName == null) {
                    throw new IllegalArgumentException("profileName is marked non-null but is null");
                }
                this.profileName = profileName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.profileName);
            }

            public String toString() {
                return "CreateProfileRequest.SpecificData.SpecificDataBuilder(profileName=" + this.profileName + ")";
            }
        }
    }
}

