/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request;

import com.google.gson.annotations.SerializedName;
import io.obswebsocket.community.client.message.Message;
import io.obswebsocket.community.client.message.request.Request;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class RequestBatch
extends Message {
    @SerializedName(value="d")
    private Data data;

    public RequestBatch(Boolean haltOnFailure, RequestBatchExecutionType executionType, List<Request> requests) {
        super(Message.OperationCode.RequestBatch);
        this.data = Data.builder().requestId(UUID.randomUUID().toString()).haltOnFailure(haltOnFailure).executionType(executionType).requests(requests.stream().map(Request::getData).collect(Collectors.toList())).build();
    }

    public static RequestBatchBuilder builder() {
        return new RequestBatchBuilder();
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "RequestBatch(super=" + super.toString() + ", data=" + this.getData() + ")";
    }

    public static class RequestBatchBuilder {
        private Boolean haltOnFailure;
        private RequestBatchExecutionType executionType;
        private ArrayList<Request> requests;

        RequestBatchBuilder() {
        }

        public RequestBatchBuilder haltOnFailure(Boolean haltOnFailure) {
            this.haltOnFailure = haltOnFailure;
            return this;
        }

        public RequestBatchBuilder executionType(RequestBatchExecutionType executionType) {
            this.executionType = executionType;
            return this;
        }

        public RequestBatchBuilder request(Request request) {
            if (this.requests == null) {
                this.requests = new ArrayList();
            }
            this.requests.add(request);
            return this;
        }

        public RequestBatchBuilder requests(Collection<? extends Request> requests) {
            if (requests == null) {
                throw new IllegalArgumentException("requests cannot be null");
            }
            if (this.requests == null) {
                this.requests = new ArrayList();
            }
            this.requests.addAll(requests);
            return this;
        }

        public RequestBatchBuilder clearRequests() {
            if (this.requests != null) {
                this.requests.clear();
            }
            return this;
        }

        public RequestBatch build() {
            List<Request> requests;
            switch (this.requests == null ? 0 : this.requests.size()) {
                case 0: {
                    requests = Collections.emptyList();
                    break;
                }
                case 1: {
                    requests = Collections.singletonList(this.requests.get(0));
                    break;
                }
                default: {
                    requests = Collections.unmodifiableList(new ArrayList<Request>(this.requests));
                }
            }
            return new RequestBatch(this.haltOnFailure, this.executionType, requests);
        }

        public String toString() {
            return "RequestBatch.RequestBatchBuilder(haltOnFailure=" + this.haltOnFailure + ", executionType=" + (Object)((Object)this.executionType) + ", requests=" + this.requests + ")";
        }
    }

    public static enum RequestBatchExecutionType {
        SerialRealtime,
        SerialFrame,
        Parallel;

    }

    public static class Data {
        private String requestId;
        private Boolean haltOnFailure;
        protected RequestBatchExecutionType executionType;
        private List<Object> requests;

        Data(String requestId, Boolean haltOnFailure, RequestBatchExecutionType executionType, List<Object> requests) {
            this.requestId = requestId;
            this.haltOnFailure = haltOnFailure;
            this.executionType = executionType;
            this.requests = requests;
        }

        public static DataBuilder builder() {
            return new DataBuilder();
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Boolean getHaltOnFailure() {
            return this.haltOnFailure;
        }

        public RequestBatchExecutionType getExecutionType() {
            return this.executionType;
        }

        public List<Object> getRequests() {
            return this.requests;
        }

        public String toString() {
            return "RequestBatch.Data(requestId=" + this.getRequestId() + ", haltOnFailure=" + this.getHaltOnFailure() + ", executionType=" + (Object)((Object)this.getExecutionType()) + ", requests=" + this.getRequests() + ")";
        }

        public static class DataBuilder {
            private String requestId;
            private Boolean haltOnFailure;
            private RequestBatchExecutionType executionType;
            private List<Object> requests;

            DataBuilder() {
            }

            public DataBuilder requestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            public DataBuilder haltOnFailure(Boolean haltOnFailure) {
                this.haltOnFailure = haltOnFailure;
                return this;
            }

            public DataBuilder executionType(RequestBatchExecutionType executionType) {
                this.executionType = executionType;
                return this;
            }

            public DataBuilder requests(List<Object> requests) {
                this.requests = requests;
                return this;
            }

            public Data build() {
                return new Data(this.requestId, this.haltOnFailure, this.executionType, this.requests);
            }

            public String toString() {
                return "RequestBatch.Data.DataBuilder(requestId=" + this.requestId + ", haltOnFailure=" + this.haltOnFailure + ", executionType=" + (Object)((Object)this.executionType) + ", requests=" + this.requests + ")";
            }
        }
    }
}

