/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.request;

import com.google.gson.annotations.SerializedName;
import io.obswebsocket.community.client.message.Message;
import io.obswebsocket.community.client.message.request.RequestType;
import java.util.UUID;

public abstract class Request<T>
extends Message {
    @SerializedName(value="d")
    private RequestData<T> data;

    protected Request(RequestType type, T requestData) {
        super(Message.OperationCode.Request);
        this.data = ((RequestData.RequestDataBuilder)((RequestData.RequestDataBuilder)((RequestData.RequestDataBuilder)RequestData.builder().requestType(type)).requestId(UUID.randomUUID().toString())).requestData(requestData)).build();
    }

    public String getRequestId() {
        return this.data.requestId;
    }

    public RequestType getRequestType() {
        return this.data.requestType;
    }

    public RequestData<T> getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "Request(super=" + super.toString() + ", data=" + this.getData() + ")";
    }

    public static abstract class Data {
        protected RequestType requestType;
        protected String requestId;

        protected Data(DataBuilder<?, ?> b) {
            this.requestType = ((DataBuilder)b).requestType;
            this.requestId = ((DataBuilder)b).requestId;
        }

        public RequestType getRequestType() {
            return this.requestType;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String toString() {
            return "Request.Data(requestType=" + (Object)((Object)this.getRequestType()) + ", requestId=" + this.getRequestId() + ")";
        }

        public static abstract class DataBuilder<C extends Data, B extends DataBuilder<C, B>> {
            private RequestType requestType;
            private String requestId;

            protected abstract B self();

            public abstract C build();

            public B requestType(RequestType requestType) {
                this.requestType = requestType;
                return this.self();
            }

            public B requestId(String requestId) {
                this.requestId = requestId;
                return this.self();
            }

            public String toString() {
                return "Request.Data.DataBuilder(requestType=" + (Object)((Object)this.requestType) + ", requestId=" + this.requestId + ")";
            }
        }
    }

    public static class RequestData<T>
    extends Data {
        protected T requestData;

        protected RequestData(RequestDataBuilder<T, ?, ?> b) {
            super(b);
            this.requestData = ((RequestDataBuilder)b).requestData;
        }

        public static <T> RequestDataBuilder<T, ?, ?> builder() {
            return new RequestDataBuilderImpl();
        }

        public T getRequestData() {
            return this.requestData;
        }

        @Override
        public String toString() {
            return "Request.RequestData(requestData=" + this.getRequestData() + ")";
        }

        private static final class RequestDataBuilderImpl<T>
        extends RequestDataBuilder<T, RequestData<T>, RequestDataBuilderImpl<T>> {
            private RequestDataBuilderImpl() {
            }

            @Override
            protected RequestDataBuilderImpl<T> self() {
                return this;
            }

            @Override
            public RequestData<T> build() {
                return new RequestData(this);
            }
        }

        public static abstract class RequestDataBuilder<T, C extends RequestData<T>, B extends RequestDataBuilder<T, C, B>>
        extends Data.DataBuilder<C, B> {
            private T requestData;

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            public B requestData(T requestData) {
                this.requestData = requestData;
                return (B)this.self();
            }

            @Override
            public String toString() {
                return "Request.RequestData.RequestDataBuilder(super=" + super.toString() + ", requestData=" + this.requestData + ")";
            }
        }
    }
}

