/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.event.scenes;

import io.obswebsocket.community.client.message.event.Event;
import io.obswebsocket.community.client.model.Scene;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SceneListChangedEvent
extends Event<SpecificData> {
    protected SceneListChangedEvent() {
        super(Event.Intent.Scenes);
    }

    protected SceneListChangedEvent(SpecificData data) {
        super(Event.Intent.Scenes, data);
    }

    public List<Scene> getScenes() {
        return ((SpecificData)this.getMessageData().getEventData()).getScenes();
    }

    @Override
    public String toString() {
        return "SceneListChangedEvent(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<Scene> scenes;

        SpecificData(List<Scene> scenes) {
            this.scenes = scenes;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<Scene> getScenes() {
            return this.scenes;
        }

        public String toString() {
            return "SceneListChangedEvent.SpecificData(scenes=" + this.getScenes() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<Scene> scenes;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder scene(Scene scene) {
                if (this.scenes == null) {
                    this.scenes = new ArrayList();
                }
                this.scenes.add(scene);
                return this;
            }

            public SpecificDataBuilder scenes(Collection<? extends Scene> scenes) {
                if (scenes == null) {
                    throw new IllegalArgumentException("scenes cannot be null");
                }
                if (this.scenes == null) {
                    this.scenes = new ArrayList();
                }
                this.scenes.addAll(scenes);
                return this;
            }

            public SpecificDataBuilder clearScenes() {
                if (this.scenes != null) {
                    this.scenes.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<Scene> scenes;
                switch (this.scenes == null ? 0 : this.scenes.size()) {
                    case 0: {
                        scenes = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        scenes = Collections.singletonList(this.scenes.get(0));
                        break;
                    }
                    default: {
                        scenes = Collections.unmodifiableList(new ArrayList<Scene>(this.scenes));
                    }
                }
                return new SpecificData(scenes);
            }

            public String toString() {
                return "SceneListChangedEvent.SpecificData.SpecificDataBuilder(scenes=" + this.scenes + ")";
            }
        }
    }
}

