/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.event.sceneitems;

import io.obswebsocket.community.client.message.event.Event;
import io.obswebsocket.community.client.model.SceneItemIdAndIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SceneItemListReindexedEvent
extends Event<SpecificData> {
    protected SceneItemListReindexedEvent() {
        super(Event.Intent.SceneItems);
    }

    protected SceneItemListReindexedEvent(SpecificData data) {
        super(Event.Intent.SceneItems, data);
    }

    public String getSceneName() {
        return ((SpecificData)this.getMessageData().getEventData()).getSceneName();
    }

    public List<SceneItemIdAndIndex> getSceneItems() {
        return ((SpecificData)this.getMessageData().getEventData()).getSceneItems();
    }

    @Override
    public String toString() {
        return "SceneItemListReindexedEvent(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private String sceneName;
        private List<SceneItemIdAndIndex> sceneItems;

        SpecificData(String sceneName, List<SceneItemIdAndIndex> sceneItems) {
            this.sceneName = sceneName;
            this.sceneItems = sceneItems;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public String getSceneName() {
            return this.sceneName;
        }

        public List<SceneItemIdAndIndex> getSceneItems() {
            return this.sceneItems;
        }

        public String toString() {
            return "SceneItemListReindexedEvent.SpecificData(sceneName=" + this.getSceneName() + ", sceneItems=" + this.getSceneItems() + ")";
        }

        public static class SpecificDataBuilder {
            private String sceneName;
            private ArrayList<SceneItemIdAndIndex> sceneItems;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneName(String sceneName) {
                this.sceneName = sceneName;
                return this;
            }

            public SpecificDataBuilder sceneItem(SceneItemIdAndIndex sceneItem) {
                if (this.sceneItems == null) {
                    this.sceneItems = new ArrayList();
                }
                this.sceneItems.add(sceneItem);
                return this;
            }

            public SpecificDataBuilder sceneItems(Collection<? extends SceneItemIdAndIndex> sceneItems) {
                if (sceneItems == null) {
                    throw new IllegalArgumentException("sceneItems cannot be null");
                }
                if (this.sceneItems == null) {
                    this.sceneItems = new ArrayList();
                }
                this.sceneItems.addAll(sceneItems);
                return this;
            }

            public SpecificDataBuilder clearSceneItems() {
                if (this.sceneItems != null) {
                    this.sceneItems.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<SceneItemIdAndIndex> sceneItems;
                switch (this.sceneItems == null ? 0 : this.sceneItems.size()) {
                    case 0: {
                        sceneItems = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sceneItems = Collections.singletonList(this.sceneItems.get(0));
                        break;
                    }
                    default: {
                        sceneItems = Collections.unmodifiableList(new ArrayList<SceneItemIdAndIndex>(this.sceneItems));
                    }
                }
                return new SpecificData(this.sceneName, sceneItems);
            }

            public String toString() {
                return "SceneItemListReindexedEvent.SpecificData.SpecificDataBuilder(sceneName=" + this.sceneName + ", sceneItems=" + this.sceneItems + ")";
            }
        }
    }
}

