/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.event.mediainputs;

import io.obswebsocket.community.client.message.event.Event;

public class MediaInputActionTriggeredEvent
extends Event<SpecificData> {
    protected MediaInputActionTriggeredEvent() {
        super(Event.Intent.MediaInputs);
    }

    protected MediaInputActionTriggeredEvent(SpecificData data) {
        super(Event.Intent.MediaInputs, data);
    }

    public String getInputName() {
        return ((SpecificData)this.getMessageData().getEventData()).getInputName();
    }

    public String getMediaAction() {
        return ((SpecificData)this.getMessageData().getEventData()).getMediaAction();
    }

    @Override
    public String toString() {
        return "MediaInputActionTriggeredEvent(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private String inputName;
        private String mediaAction;

        SpecificData(String inputName, String mediaAction) {
            this.inputName = inputName;
            this.mediaAction = mediaAction;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public String getInputName() {
            return this.inputName;
        }

        public String getMediaAction() {
            return this.mediaAction;
        }

        public String toString() {
            return "MediaInputActionTriggeredEvent.SpecificData(inputName=" + this.getInputName() + ", mediaAction=" + this.getMediaAction() + ")";
        }

        public static class SpecificDataBuilder {
            private String inputName;
            private String mediaAction;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder inputName(String inputName) {
                this.inputName = inputName;
                return this;
            }

            public SpecificDataBuilder mediaAction(String mediaAction) {
                this.mediaAction = mediaAction;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.inputName, this.mediaAction);
            }

            public String toString() {
                return "MediaInputActionTriggeredEvent.SpecificData.SpecificDataBuilder(inputName=" + this.inputName + ", mediaAction=" + this.mediaAction + ")";
            }
        }
    }
}

