/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.event.inputs;

import io.obswebsocket.community.client.message.event.Event;
import io.obswebsocket.community.client.model.InputLevels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InputVolumeMetersEvent
extends Event<SpecificData> {
    protected InputVolumeMetersEvent() {
        super(Event.Intent.InputVolumeMeters);
    }

    protected InputVolumeMetersEvent(SpecificData data) {
        super(Event.Intent.InputVolumeMeters, data);
    }

    public List<InputLevels> getInputs() {
        return ((SpecificData)this.getMessageData().getEventData()).getInputs();
    }

    @Override
    public String toString() {
        return "InputVolumeMetersEvent(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<InputLevels> inputs;

        SpecificData(List<InputLevels> inputs) {
            this.inputs = inputs;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<InputLevels> getInputs() {
            return this.inputs;
        }

        public String toString() {
            return "InputVolumeMetersEvent.SpecificData(inputs=" + this.getInputs() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<InputLevels> inputs;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder input(InputLevels input) {
                if (this.inputs == null) {
                    this.inputs = new ArrayList();
                }
                this.inputs.add(input);
                return this;
            }

            public SpecificDataBuilder inputs(Collection<? extends InputLevels> inputs) {
                if (inputs == null) {
                    throw new IllegalArgumentException("inputs cannot be null");
                }
                if (this.inputs == null) {
                    this.inputs = new ArrayList();
                }
                this.inputs.addAll(inputs);
                return this;
            }

            public SpecificDataBuilder clearInputs() {
                if (this.inputs != null) {
                    this.inputs.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<InputLevels> inputs;
                switch (this.inputs == null ? 0 : this.inputs.size()) {
                    case 0: {
                        inputs = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        inputs = Collections.singletonList(this.inputs.get(0));
                        break;
                    }
                    default: {
                        inputs = Collections.unmodifiableList(new ArrayList<InputLevels>(this.inputs));
                    }
                }
                return new SpecificData(inputs);
            }

            public String toString() {
                return "InputVolumeMetersEvent.SpecificData.SpecificDataBuilder(inputs=" + this.inputs + ")";
            }
        }
    }
}

