/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.event.filters;

import io.obswebsocket.community.client.message.event.Event;

public class SourceFilterNameChangedEvent
extends Event<SpecificData> {
    protected SourceFilterNameChangedEvent() {
        super(Event.Intent.Filters);
    }

    protected SourceFilterNameChangedEvent(SpecificData data) {
        super(Event.Intent.Filters, data);
    }

    public String getSourceName() {
        return ((SpecificData)this.getMessageData().getEventData()).getSourceName();
    }

    public String getOldFilterName() {
        return ((SpecificData)this.getMessageData().getEventData()).getOldFilterName();
    }

    public String getFilterName() {
        return ((SpecificData)this.getMessageData().getEventData()).getFilterName();
    }

    @Override
    public String toString() {
        return "SourceFilterNameChangedEvent(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private String sourceName;
        private String oldFilterName;
        private String filterName;

        SpecificData(String sourceName, String oldFilterName, String filterName) {
            this.sourceName = sourceName;
            this.oldFilterName = oldFilterName;
            this.filterName = filterName;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String getOldFilterName() {
            return this.oldFilterName;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String toString() {
            return "SourceFilterNameChangedEvent.SpecificData(sourceName=" + this.getSourceName() + ", oldFilterName=" + this.getOldFilterName() + ", filterName=" + this.getFilterName() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private String oldFilterName;
            private String filterName;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(String sourceName) {
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder oldFilterName(String oldFilterName) {
                this.oldFilterName = oldFilterName;
                return this;
            }

            public SpecificDataBuilder filterName(String filterName) {
                this.filterName = filterName;
                return this;
            }

            public SpecificData build() {
                return new SpecificData(this.sourceName, this.oldFilterName, this.filterName);
            }

            public String toString() {
                return "SourceFilterNameChangedEvent.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", oldFilterName=" + this.oldFilterName + ", filterName=" + this.filterName + ")";
            }
        }
    }
}

