/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.event.filters;

import io.obswebsocket.community.client.message.event.Event;
import io.obswebsocket.community.client.model.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SourceFilterListReindexedEvent
extends Event<SpecificData> {
    protected SourceFilterListReindexedEvent() {
        super(Event.Intent.Filters);
    }

    protected SourceFilterListReindexedEvent(SpecificData data) {
        super(Event.Intent.Filters, data);
    }

    public String getSourceName() {
        return ((SpecificData)this.getMessageData().getEventData()).getSourceName();
    }

    public List<Filter> getFilters() {
        return ((SpecificData)this.getMessageData().getEventData()).getFilters();
    }

    @Override
    public String toString() {
        return "SourceFilterListReindexedEvent(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private String sourceName;
        private List<Filter> filters;

        SpecificData(String sourceName, List<Filter> filters) {
            this.sourceName = sourceName;
            this.filters = filters;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public String toString() {
            return "SourceFilterListReindexedEvent.SpecificData(sourceName=" + this.getSourceName() + ", filters=" + this.getFilters() + ")";
        }

        public static class SpecificDataBuilder {
            private String sourceName;
            private ArrayList<Filter> filters;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sourceName(String sourceName) {
                this.sourceName = sourceName;
                return this;
            }

            public SpecificDataBuilder filter(Filter filter) {
                if (this.filters == null) {
                    this.filters = new ArrayList();
                }
                this.filters.add(filter);
                return this;
            }

            public SpecificDataBuilder filters(Collection<? extends Filter> filters) {
                if (filters == null) {
                    throw new IllegalArgumentException("filters cannot be null");
                }
                if (this.filters == null) {
                    this.filters = new ArrayList();
                }
                this.filters.addAll(filters);
                return this;
            }

            public SpecificDataBuilder clearFilters() {
                if (this.filters != null) {
                    this.filters.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<Filter> filters;
                switch (this.filters == null ? 0 : this.filters.size()) {
                    case 0: {
                        filters = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        filters = Collections.singletonList(this.filters.get(0));
                        break;
                    }
                    default: {
                        filters = Collections.unmodifiableList(new ArrayList<Filter>(this.filters));
                    }
                }
                return new SpecificData(this.sourceName, filters);
            }

            public String toString() {
                return "SourceFilterListReindexedEvent.SpecificData.SpecificDataBuilder(sourceName=" + this.sourceName + ", filters=" + this.filters + ")";
            }
        }
    }
}

