/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.event.config;

import io.obswebsocket.community.client.message.event.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SceneCollectionListChangedEvent
extends Event<SpecificData> {
    protected SceneCollectionListChangedEvent() {
        super(Event.Intent.Config);
    }

    protected SceneCollectionListChangedEvent(SpecificData data) {
        super(Event.Intent.Config, data);
    }

    public List<String> getSceneCollections() {
        return ((SpecificData)this.getMessageData().getEventData()).getSceneCollections();
    }

    @Override
    public String toString() {
        return "SceneCollectionListChangedEvent(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<String> sceneCollections;

        SpecificData(List<String> sceneCollections) {
            this.sceneCollections = sceneCollections;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<String> getSceneCollections() {
            return this.sceneCollections;
        }

        public String toString() {
            return "SceneCollectionListChangedEvent.SpecificData(sceneCollections=" + this.getSceneCollections() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<String> sceneCollections;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder sceneCollection(String sceneCollection) {
                if (this.sceneCollections == null) {
                    this.sceneCollections = new ArrayList();
                }
                this.sceneCollections.add(sceneCollection);
                return this;
            }

            public SpecificDataBuilder sceneCollections(Collection<? extends String> sceneCollections) {
                if (sceneCollections == null) {
                    throw new IllegalArgumentException("sceneCollections cannot be null");
                }
                if (this.sceneCollections == null) {
                    this.sceneCollections = new ArrayList();
                }
                this.sceneCollections.addAll(sceneCollections);
                return this;
            }

            public SpecificDataBuilder clearSceneCollections() {
                if (this.sceneCollections != null) {
                    this.sceneCollections.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<String> sceneCollections;
                switch (this.sceneCollections == null ? 0 : this.sceneCollections.size()) {
                    case 0: {
                        sceneCollections = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sceneCollections = Collections.singletonList(this.sceneCollections.get(0));
                        break;
                    }
                    default: {
                        sceneCollections = Collections.unmodifiableList(new ArrayList<String>(this.sceneCollections));
                    }
                }
                return new SpecificData(sceneCollections);
            }

            public String toString() {
                return "SceneCollectionListChangedEvent.SpecificData.SpecificDataBuilder(sceneCollections=" + this.sceneCollections + ")";
            }
        }
    }
}

