/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.event.config;

import io.obswebsocket.community.client.message.event.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ProfileListChangedEvent
extends Event<SpecificData> {
    protected ProfileListChangedEvent() {
        super(Event.Intent.Config);
    }

    protected ProfileListChangedEvent(SpecificData data) {
        super(Event.Intent.Config, data);
    }

    public List<String> getProfiles() {
        return ((SpecificData)this.getMessageData().getEventData()).getProfiles();
    }

    @Override
    public String toString() {
        return "ProfileListChangedEvent(super=" + super.toString() + ")";
    }

    public static class SpecificData {
        private List<String> profiles;

        SpecificData(List<String> profiles) {
            this.profiles = profiles;
        }

        public static SpecificDataBuilder builder() {
            return new SpecificDataBuilder();
        }

        public List<String> getProfiles() {
            return this.profiles;
        }

        public String toString() {
            return "ProfileListChangedEvent.SpecificData(profiles=" + this.getProfiles() + ")";
        }

        public static class SpecificDataBuilder {
            private ArrayList<String> profiles;

            SpecificDataBuilder() {
            }

            public SpecificDataBuilder profile(String profile) {
                if (this.profiles == null) {
                    this.profiles = new ArrayList();
                }
                this.profiles.add(profile);
                return this;
            }

            public SpecificDataBuilder profiles(Collection<? extends String> profiles) {
                if (profiles == null) {
                    throw new IllegalArgumentException("profiles cannot be null");
                }
                if (this.profiles == null) {
                    this.profiles = new ArrayList();
                }
                this.profiles.addAll(profiles);
                return this;
            }

            public SpecificDataBuilder clearProfiles() {
                if (this.profiles != null) {
                    this.profiles.clear();
                }
                return this;
            }

            public SpecificData build() {
                List<String> profiles;
                switch (this.profiles == null ? 0 : this.profiles.size()) {
                    case 0: {
                        profiles = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        profiles = Collections.singletonList(this.profiles.get(0));
                        break;
                    }
                    default: {
                        profiles = Collections.unmodifiableList(new ArrayList<String>(this.profiles));
                    }
                }
                return new SpecificData(profiles);
            }

            public String toString() {
                return "ProfileListChangedEvent.SpecificData.SpecificDataBuilder(profiles=" + this.profiles + ")";
            }
        }
    }
}

