/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.event;

import com.google.gson.annotations.SerializedName;
import io.obswebsocket.community.client.message.Message;
import io.obswebsocket.community.client.message.event.EventType;

public abstract class Event<T>
extends Message {
    @SerializedName(value="d")
    private Data<T> messageData;

    protected Event(Intent eventIntent) {
        this(eventIntent, null);
    }

    protected Event(Intent eventIntent, T messageData) {
        super(Message.OperationCode.Event);
        this.messageData = ((Data.DataBuilder)((Data.DataBuilder)((Data.DataBuilder)Data.builder().eventType(EventType.from(this.getClass()))).eventIntent(eventIntent)).eventData(messageData)).build();
    }

    public Data<T> getMessageData() {
        return this.messageData;
    }

    @Override
    public String toString() {
        return "Event(super=" + super.toString() + ", messageData=" + this.getMessageData() + ")";
    }

    public static class Data<T> {
        private EventType eventType;
        private Intent eventIntent;
        private T eventData;

        protected Data(DataBuilder<T, ?, ?> b) {
            this.eventType = ((DataBuilder)b).eventType;
            this.eventIntent = ((DataBuilder)b).eventIntent;
            this.eventData = ((DataBuilder)b).eventData;
        }

        public static <T> DataBuilder<T, ?, ?> builder() {
            return new DataBuilderImpl();
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public Intent getEventIntent() {
            return this.eventIntent;
        }

        public T getEventData() {
            return this.eventData;
        }

        public String toString() {
            return "Event.Data(eventType=" + (Object)((Object)this.getEventType()) + ", eventIntent=" + (Object)((Object)this.getEventIntent()) + ", eventData=" + this.getEventData() + ")";
        }

        private static final class DataBuilderImpl<T>
        extends DataBuilder<T, Data<T>, DataBuilderImpl<T>> {
            private DataBuilderImpl() {
            }

            @Override
            protected DataBuilderImpl<T> self() {
                return this;
            }

            @Override
            public Data<T> build() {
                return new Data(this);
            }
        }

        public static abstract class DataBuilder<T, C extends Data<T>, B extends DataBuilder<T, C, B>> {
            private EventType eventType;
            private Intent eventIntent;
            private T eventData;

            protected abstract B self();

            public abstract C build();

            public B eventType(EventType eventType) {
                this.eventType = eventType;
                return this.self();
            }

            public B eventIntent(Intent eventIntent) {
                this.eventIntent = eventIntent;
                return this.self();
            }

            public B eventData(T eventData) {
                this.eventData = eventData;
                return this.self();
            }

            public String toString() {
                return "Event.Data.DataBuilder(eventType=" + (Object)((Object)this.eventType) + ", eventIntent=" + (Object)((Object)this.eventIntent) + ", eventData=" + this.eventData + ")";
            }
        }
    }

    public static enum Intent {
        None(0),
        General(1),
        Config(2),
        Scenes(4),
        Inputs(8),
        Transitions(16),
        Filters(32),
        Outputs(64),
        SceneItems(128),
        MediaInputs(256),
        Vendors(512),
        Ui(1024),
        All(Intent.General.value | Intent.Config.value | Intent.Scenes.value | Intent.Inputs.value | Intent.Transitions.value | Intent.Filters.value | Intent.Outputs.value | Intent.SceneItems.value | Intent.MediaInputs.value | Intent.Vendors.value | Intent.Ui.value),
        InputVolumeMeters(65536),
        InputActiveStateChanged(131072),
        InputShowStateChanged(262144),
        SceneItemTransformChanged(524288);

        private final int value;

        private Intent(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

