/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message.authentication;

import com.google.gson.annotations.SerializedName;
import io.obswebsocket.community.client.message.Message;

public class Hello
extends Message {
    @SerializedName(value="d")
    private final Data messageData;

    private Hello(String obsWebSocketVersion, Data.Authentication authentication, int rpcVersion) {
        super(Message.OperationCode.Hello);
        this.messageData = Data.builder().obsWebSocketVersion(obsWebSocketVersion).authentication(authentication).rpcVersion(rpcVersion).build();
    }

    public boolean isAuthenticationRequired() {
        return this.messageData != null && this.messageData.authentication != null;
    }

    public static HelloBuilder builder() {
        return new HelloBuilder();
    }

    @Override
    public String toString() {
        return "Hello(messageData=" + this.getMessageData() + ")";
    }

    public Data getMessageData() {
        return this.messageData;
    }

    public static class HelloBuilder {
        private String obsWebSocketVersion;
        private Data.Authentication authentication;
        private int rpcVersion;

        HelloBuilder() {
        }

        public HelloBuilder obsWebSocketVersion(String obsWebSocketVersion) {
            this.obsWebSocketVersion = obsWebSocketVersion;
            return this;
        }

        public HelloBuilder authentication(Data.Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public HelloBuilder rpcVersion(int rpcVersion) {
            this.rpcVersion = rpcVersion;
            return this;
        }

        public Hello build() {
            return new Hello(this.obsWebSocketVersion, this.authentication, this.rpcVersion);
        }

        public String toString() {
            return "Hello.HelloBuilder(obsWebSocketVersion=" + this.obsWebSocketVersion + ", authentication=" + this.authentication + ", rpcVersion=" + this.rpcVersion + ")";
        }
    }

    public static class Data {
        private final String obsWebSocketVersion;
        private final Authentication authentication;
        private final int rpcVersion;

        public static DataBuilder builder() {
            return new DataBuilder();
        }

        public Data(String obsWebSocketVersion, Authentication authentication, int rpcVersion) {
            this.obsWebSocketVersion = obsWebSocketVersion;
            this.authentication = authentication;
            this.rpcVersion = rpcVersion;
        }

        public String toString() {
            return "Hello.Data(obsWebSocketVersion=" + this.getObsWebSocketVersion() + ", authentication=" + this.getAuthentication() + ", rpcVersion=" + this.getRpcVersion() + ")";
        }

        public String getObsWebSocketVersion() {
            return this.obsWebSocketVersion;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public int getRpcVersion() {
            return this.rpcVersion;
        }

        public static class DataBuilder {
            private String obsWebSocketVersion;
            private Authentication authentication;
            private int rpcVersion;

            DataBuilder() {
            }

            public DataBuilder obsWebSocketVersion(String obsWebSocketVersion) {
                this.obsWebSocketVersion = obsWebSocketVersion;
                return this;
            }

            public DataBuilder authentication(Authentication authentication) {
                this.authentication = authentication;
                return this;
            }

            public DataBuilder rpcVersion(int rpcVersion) {
                this.rpcVersion = rpcVersion;
                return this;
            }

            public Data build() {
                return new Data(this.obsWebSocketVersion, this.authentication, this.rpcVersion);
            }

            public String toString() {
                return "Hello.Data.DataBuilder(obsWebSocketVersion=" + this.obsWebSocketVersion + ", authentication=" + this.authentication + ", rpcVersion=" + this.rpcVersion + ")";
            }
        }

        public static class Authentication {
            private final String challenge;
            private final String salt;

            public static AuthenticationBuilder builder() {
                return new AuthenticationBuilder();
            }

            public Authentication(String challenge, String salt) {
                this.challenge = challenge;
                this.salt = salt;
            }

            public String toString() {
                return "Hello.Data.Authentication(challenge=" + this.getChallenge() + ", salt=" + this.getSalt() + ")";
            }

            public String getChallenge() {
                return this.challenge;
            }

            public String getSalt() {
                return this.salt;
            }

            public static class AuthenticationBuilder {
                private String challenge;
                private String salt;

                AuthenticationBuilder() {
                }

                public AuthenticationBuilder challenge(String challenge) {
                    this.challenge = challenge;
                    return this;
                }

                public AuthenticationBuilder salt(String salt) {
                    this.salt = salt;
                    return this;
                }

                public Authentication build() {
                    return new Authentication(this.challenge, this.salt);
                }

                public String toString() {
                    return "Hello.Data.Authentication.AuthenticationBuilder(challenge=" + this.challenge + ", salt=" + this.salt + ")";
                }
            }
        }
    }
}

