/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.obswebsocket.community.client.message.Message;
import java.lang.reflect.Type;

public class MessageSerialization
implements JsonDeserializer<Message>,
JsonSerializer<Message> {
    public Message deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject;
        Message message = null;
        if (jsonElement.isJsonObject() && (jsonObject = jsonElement.getAsJsonObject()).has("op")) {
            Message.OperationCode messageOperationCode = null;
            try {
                messageOperationCode = Message.OperationCode.fromRawCode(jsonObject.get("op").getAsLong());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (messageOperationCode != null) {
                message = (Message)context.deserialize(jsonElement, messageOperationCode.getMessageClass());
            }
        }
        return message;
    }

    public JsonElement serialize(Message src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }
}

