/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.message;

import com.google.gson.annotations.SerializedName;
import io.obswebsocket.community.client.message.authentication.Hello;
import io.obswebsocket.community.client.message.authentication.Identified;
import io.obswebsocket.community.client.message.authentication.Identify;
import io.obswebsocket.community.client.message.authentication.Reidentify;
import io.obswebsocket.community.client.message.event.Event;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestBatch;
import io.obswebsocket.community.client.message.response.RequestBatchResponse;
import io.obswebsocket.community.client.message.response.RequestResponse;
import java.util.Arrays;

public abstract class Message {
    @SerializedName(value="op")
    protected OperationCode operationCode;

    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    protected Message(OperationCode operationCode) {
        this.operationCode = operationCode;
    }

    public String toString() {
        return "Message(operationCode=" + (Object)((Object)this.getOperationCode()) + ")";
    }

    public static enum OperationCode {
        Hello(0L, Hello.class),
        Identify(1L, Identify.class),
        Identified(2L, Identified.class),
        Reidentify(3L, Reidentify.class),
        Event(5L, Event.class),
        Request(6L, Request.class),
        RequestResponse(7L, RequestResponse.class),
        RequestBatch(8L, RequestBatch.class),
        RequestBatchResponse(9L, RequestBatchResponse.class);

        private final long rawCode;
        private final Class<? extends Message> messageClass;

        private OperationCode(Long rawCode, Class<? extends Message> messageClass) {
            this.rawCode = rawCode;
            this.messageClass = messageClass;
        }

        static OperationCode fromRawCode(long rawCode) {
            return Arrays.stream(OperationCode.values()).filter(operationCode -> operationCode.rawCode == rawCode).findFirst().orElse(null);
        }

        public long getRawCode() {
            return this.rawCode;
        }

        public Class<? extends Message> getMessageClass() {
            return this.messageClass;
        }
    }
}

