/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.listener.lifecycle.controller;

import io.obswebsocket.community.client.listener.lifecycle.ReasonThrowable;
import io.obswebsocket.community.client.listener.lifecycle.controller.ControllerLifecycleListener;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingControllerLifecycleListener
implements ControllerLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(DelegatingControllerLifecycleListener.class);
    private final Consumer<ReasonThrowable> onErrorCallback;

    public DelegatingControllerLifecycleListener(Consumer<ReasonThrowable> onErrorCallback) {
        this.onErrorCallback = onErrorCallback;
    }

    @Override
    public void onError(ReasonThrowable reasonThrowable) {
        if (this.onErrorCallback != null) {
            try {
                this.onErrorCallback.accept(reasonThrowable);
            }
            catch (Exception e) {
                log.warn("onError callback (ironically) threw exception", (Throwable)e);
            }
        }
    }
}

