/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.listener.lifecycle.controller;

import io.obswebsocket.community.client.OBSRemoteControllerBuilder;
import io.obswebsocket.community.client.listener.lifecycle.ReasonThrowable;
import io.obswebsocket.community.client.listener.lifecycle.controller.CompositeControllerLifecycleListener;
import io.obswebsocket.community.client.listener.lifecycle.controller.ControllerLifecycleListener;
import io.obswebsocket.community.client.listener.lifecycle.controller.DelegatingControllerLifecycleListener;
import io.obswebsocket.community.client.listener.lifecycle.controller.LoggingControllerLifecycleListener;
import java.util.ArrayList;
import java.util.function.Consumer;

public class ControllerLifecycleListenerBuilder {
    private final OBSRemoteControllerBuilder obsRemoteControllerBuilder;
    private Consumer<ReasonThrowable> onErrorCallback;
    private boolean defaultLogging = true;

    public ControllerLifecycleListenerBuilder(OBSRemoteControllerBuilder obsRemoteControllerBuilder) {
        this.obsRemoteControllerBuilder = obsRemoteControllerBuilder;
    }

    public ControllerLifecycleListenerBuilder onError(Consumer<ReasonThrowable> onErrorCallback) {
        this.onErrorCallback = onErrorCallback;
        return this;
    }

    public ControllerLifecycleListenerBuilder withDefaultLogging(boolean defaultLogging) {
        this.defaultLogging = defaultLogging;
        return this;
    }

    public OBSRemoteControllerBuilder and() {
        return this.obsRemoteControllerBuilder;
    }

    public CompositeControllerLifecycleListener build() {
        ArrayList<ControllerLifecycleListener> listeners = new ArrayList<ControllerLifecycleListener>();
        listeners.add(new DelegatingControllerLifecycleListener(this.onErrorCallback));
        if (this.defaultLogging) {
            listeners.add(new LoggingControllerLifecycleListener());
        }
        return new CompositeControllerLifecycleListener(listeners);
    }
}

