/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.listener.lifecycle.communicator;

import io.obswebsocket.community.client.WebSocketCloseCode;
import io.obswebsocket.community.client.listener.lifecycle.ReasonThrowable;
import io.obswebsocket.community.client.listener.lifecycle.communicator.CommunicatorLifecycleListener;
import io.obswebsocket.community.client.message.authentication.Hello;
import io.obswebsocket.community.client.message.authentication.Identified;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCommunicatorLifecycleListener
implements CommunicatorLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingCommunicatorLifecycleListener.class);

    @Override
    public void onConnect(Session session) {
        log.info("Connected to OBS at: " + session.getRemoteAddress());
    }

    @Override
    public void onHello(Hello hello) {
        log.debug("onHello: " + hello);
    }

    @Override
    public void onIdentified(Identified identified) {
        log.debug("onIdentified: " + identified);
    }

    @Override
    public void onReady() {
        log.info("Client is ready to accept requests");
    }

    @Override
    public void onClose(WebSocketCloseCode webSocketCloseCode) {
        log.info(String.format("Connection closed: %d - %s%n", webSocketCloseCode.getCode(), webSocketCloseCode.name()));
    }

    @Override
    public void onDisconnect() {
        log.info("Client is now disconnected");
    }

    @Override
    public void onError(ReasonThrowable reasonThrowable) {
        log.error("onError: " + reasonThrowable.getReason(), reasonThrowable.getThrowable());
    }
}

