/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.listener.lifecycle.communicator;

import io.obswebsocket.community.client.WebSocketCloseCode;
import io.obswebsocket.community.client.listener.lifecycle.ReasonThrowable;
import io.obswebsocket.community.client.listener.lifecycle.communicator.CommunicatorLifecycleListener;
import io.obswebsocket.community.client.message.authentication.Hello;
import io.obswebsocket.community.client.message.authentication.Identified;
import java.util.function.Consumer;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingCommunicatorLifecycleListener
implements CommunicatorLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(DelegatingCommunicatorLifecycleListener.class);
    private final Consumer<Session> onConnectCallback;
    private final Consumer<Hello> onHelloCallback;
    private final Consumer<Identified> onIdentifiedCallback;
    private final Runnable onReadyCallback;
    private final Consumer<WebSocketCloseCode> onCloseCallback;
    private final Runnable onDisconnectCallback;
    private final Consumer<ReasonThrowable> onErrorCallback;

    public DelegatingCommunicatorLifecycleListener(Consumer<Session> onConnectCallback, Consumer<Hello> onHelloCallback, Consumer<Identified> onIdentifiedCallback, Runnable onReadyCallback, Consumer<WebSocketCloseCode> onCloseCallback, Runnable onDisconnectCallback, Consumer<ReasonThrowable> onErrorCallback) {
        this.onConnectCallback = onConnectCallback;
        this.onHelloCallback = onHelloCallback;
        this.onIdentifiedCallback = onIdentifiedCallback;
        this.onReadyCallback = onReadyCallback;
        this.onCloseCallback = onCloseCallback;
        this.onDisconnectCallback = onDisconnectCallback;
        this.onErrorCallback = onErrorCallback;
    }

    @Override
    public void onConnect(Session session) {
        if (this.onConnectCallback != null) {
            try {
                this.onConnectCallback.accept(session);
            }
            catch (Exception e) {
                log.warn("onConnect callback threw exception", (Throwable)e);
            }
        }
    }

    @Override
    public void onHello(Hello hello) {
        if (this.onHelloCallback != null) {
            try {
                this.onHelloCallback.accept(hello);
            }
            catch (Exception e) {
                log.warn("onHello callback threw exception", (Throwable)e);
            }
        }
    }

    @Override
    public void onIdentified(Identified identified) {
        if (this.onIdentifiedCallback != null) {
            try {
                this.onIdentifiedCallback.accept(identified);
            }
            catch (Exception e) {
                log.warn("onIdentified callback threw exception", (Throwable)e);
            }
        }
    }

    @Override
    public void onReady() {
        if (this.onReadyCallback != null) {
            try {
                this.onReadyCallback.run();
            }
            catch (Exception e) {
                log.warn("onReady callback threw exception", (Throwable)e);
            }
        }
    }

    @Override
    public void onClose(WebSocketCloseCode webSocketCloseCode) {
        if (this.onCloseCallback != null) {
            try {
                this.onCloseCallback.accept(webSocketCloseCode);
            }
            catch (Exception e) {
                log.warn("onClose callback threw exception", (Throwable)e);
            }
        }
    }

    @Override
    public void onDisconnect() {
        if (this.onDisconnectCallback != null) {
            try {
                this.onDisconnectCallback.run();
            }
            catch (Exception e) {
                log.warn("onDisconnect callback threw exception", (Throwable)e);
            }
        }
    }

    @Override
    public void onError(ReasonThrowable reasonThrowable) {
        if (this.onErrorCallback != null) {
            try {
                this.onErrorCallback.accept(reasonThrowable);
            }
            catch (Exception e) {
                log.warn("onError callback (ironically) threw an exception", (Throwable)e);
            }
        }
    }
}

