/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client.listener.event;

import io.obswebsocket.community.client.listener.event.OBSEventListener;
import io.obswebsocket.community.client.message.event.Event;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class OBSEventListenerImpl
implements OBSEventListener {
    private final ConcurrentHashMap<Class<? extends Event>, Consumer> eventListeners = new ConcurrentHashMap();

    public OBSEventListenerImpl(ConcurrentHashMap<Class<? extends Event>, Consumer> eventListeners) {
        if (eventListeners != null) {
            this.eventListeners.putAll(eventListeners);
        }
    }

    @Override
    public void onEvent(Event event) {
        if (this.eventListeners.containsKey(event.getClass())) {
            this.eventListeners.get(event.getClass()).accept(event);
        }
    }

    @Override
    public int computeEventSubscription() {
        return this.eventListeners.keySet().stream().map(aClass -> {
            Event.Intent intent = Event.Intent.None;
            try {
                Constructor constructor = aClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Event instance = (Event)constructor.newInstance(new Object[0]);
                intent = instance.getMessageData().getEventIntent();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return intent;
        }).mapToInt(Event.Intent::getValue).reduce(Event.Intent.None.getValue(), (a, b) -> a | b);
    }
}

