/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client;

import java.util.Arrays;

public enum WebSocketCloseCode {
    UnknownCode(-1),
    DontClose(0),
    UnknownReason(4000),
    MessageDecodeError(4002),
    MissingDataField(4003),
    InvalidDataFieldType(4004),
    InvalidDataFieldValue(4005),
    UnknownOpCode(4006),
    NotIdentified(4007),
    AlreadyIdentified(4008),
    AuthenticationFailed(4009),
    UnsupportedRpcVersion(4010),
    SessionInvalidated(4011),
    UnsupportedFeature(4012);

    private final int code;

    private WebSocketCloseCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static WebSocketCloseCode fromCode(int code) {
        return Arrays.stream(WebSocketCloseCode.values()).filter(it -> it.getCode() == code).findFirst().orElseThrow(() -> new IllegalArgumentException("Code is invalid"));
    }
}

