/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client;

import io.obswebsocket.community.client.OBSCommunicator;
import io.obswebsocket.community.client.OBSRemoteControllerBase;
import io.obswebsocket.community.client.OBSRemoteControllerBuilder;
import io.obswebsocket.community.client.listener.lifecycle.ReasonThrowable;
import io.obswebsocket.community.client.listener.lifecycle.controller.ControllerLifecycleListener;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestBatch;
import io.obswebsocket.community.client.message.response.RequestBatchResponse;
import io.obswebsocket.community.client.message.response.RequestResponse;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBSRemoteController
extends OBSRemoteControllerBase {
    private static final Logger log = LoggerFactory.getLogger(OBSRemoteController.class);
    private final URI uri;
    private final OBSCommunicator communicator;
    private final WebSocketClient webSocketClient;
    private final int connectionTimeoutSeconds;
    private final ControllerLifecycleListener controllerLifecycleListener;

    public OBSRemoteController(WebSocketClient webSocketClient, OBSCommunicator communicator, ControllerLifecycleListener controllerLifecycleListener, String host, int port, int connectionTimeoutSeconds, boolean autoConnect) {
        if (connectionTimeoutSeconds < 0) {
            throw new IllegalArgumentException("Connection timeout must be greater than zero");
        }
        this.webSocketClient = webSocketClient;
        this.communicator = communicator;
        this.controllerLifecycleListener = controllerLifecycleListener;
        try {
            this.uri = new URI("ws://" + host + ":" + port);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Host or Port are invalid");
        }
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        if (autoConnect) {
            this.connect();
        }
    }

    public static OBSRemoteControllerBuilder builder() {
        return new OBSRemoteControllerBuilder();
    }

    public void connect() {
        try {
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            if (!this.webSocketClient.isStarted() || !this.webSocketClient.isStarting()) {
                this.webSocketClient.start();
            }
            Future connection = this.webSocketClient.connect((Object)this.communicator, this.uri, request);
            log.debug(String.format("Connecting to: %s", this.uri));
            connection.get(this.connectionTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            if (t instanceof TimeoutException || t instanceof ExecutionException && t.getCause() != null && t.getCause() instanceof ConnectException || t instanceof ExecutionException && t.getCause() != null && t.getCause() instanceof UnknownHostException) {
                this.controllerLifecycleListener.onError(new ReasonThrowable("Could not contact OBS on: " + this.uri + ", verify OBS is running, the plugin is installed, and it can be reached over the network", t.getCause() == null ? t : t.getCause()));
            }
            this.controllerLifecycleListener.onError(new ReasonThrowable("An unexpected exception occurred during connect", t));
        }
    }

    public void disconnect() {
        try {
            log.debug("Closing connection.");
            this.communicator.closeAndAwait(this.connectionTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.controllerLifecycleListener.onError(new ReasonThrowable("Error during closing websocket connection", e));
        }
    }

    public void stop() {
        if (!this.webSocketClient.isStopped() || !this.webSocketClient.isStopping()) {
            try {
                log.debug("Stopping client.");
                this.webSocketClient.stop();
            }
            catch (Exception e) {
                this.controllerLifecycleListener.onError(new ReasonThrowable("Error during stopping websocket client", e));
            }
        }
    }

    public void await() throws InterruptedException {
        this.communicator.await();
    }

    @Override
    public <R extends Request, RR extends RequestResponse> void sendRequest(R request, Consumer<RR> callback) {
        this.communicator.sendRequest(request, callback);
    }

    public void sendRequestBatch(RequestBatch requestBatch, Consumer<RequestBatchResponse> callback) {
        this.communicator.sendRequestBatch(requestBatch, callback);
    }
}

