/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client;

import com.google.gson.JsonSyntaxException;
import io.obswebsocket.community.client.OBSCommunicatorBuilder;
import io.obswebsocket.community.client.WebSocketCloseCode;
import io.obswebsocket.community.client.authenticator.Authenticator;
import io.obswebsocket.community.client.listener.event.OBSEventListener;
import io.obswebsocket.community.client.listener.lifecycle.ReasonThrowable;
import io.obswebsocket.community.client.listener.lifecycle.communicator.CommunicatorLifecycleListener;
import io.obswebsocket.community.client.listener.request.ObsRequestListener;
import io.obswebsocket.community.client.message.Message;
import io.obswebsocket.community.client.message.authentication.Hello;
import io.obswebsocket.community.client.message.authentication.Identified;
import io.obswebsocket.community.client.message.authentication.Identify;
import io.obswebsocket.community.client.message.event.Event;
import io.obswebsocket.community.client.message.request.Request;
import io.obswebsocket.community.client.message.request.RequestBatch;
import io.obswebsocket.community.client.message.response.RequestBatchResponse;
import io.obswebsocket.community.client.message.response.RequestResponse;
import io.obswebsocket.community.client.translator.MessageTranslator;
import java.lang.reflect.Type;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=0x100000, maxIdleTime=360000000)
public class OBSCommunicator {
    private static final Logger log = LoggerFactory.getLogger(OBSCommunicator.class);
    public static final Integer RPC_VERSION = 1;
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final MessageTranslator translator;
    private final Authenticator authenticator;
    private final OBSEventListener obsEventListener;
    private final ObsRequestListener obsRequestListener;
    private Session session;
    private final CommunicatorLifecycleListener communicatorLifecycleListener;

    public OBSCommunicator(MessageTranslator translator, Authenticator authenticator, CommunicatorLifecycleListener communicatorLifecycleListener, ObsRequestListener obsRequestListener, OBSEventListener obsEventListener) {
        this.translator = translator;
        this.authenticator = authenticator;
        this.communicatorLifecycleListener = communicatorLifecycleListener;
        this.obsRequestListener = obsRequestListener;
        this.obsEventListener = obsEventListener;
    }

    public static OBSCommunicatorBuilder builder() {
        return new OBSCommunicatorBuilder();
    }

    public boolean closeAndAwait(int duration, TimeUnit unit) throws InterruptedException {
        if (this.session != null) {
            this.session.close();
        }
        return this.closeLatch.await(duration, unit);
    }

    public void await() throws InterruptedException {
        this.closeLatch.await();
    }

    @OnWebSocketError
    public void onError(Session session, Throwable t) {
        this.communicatorLifecycleListener.onError(new ReasonThrowable("Websocket error occurred with session " + session, t));
        if (this.session != null) {
            this.session.close(4000, "An exception was thrown with message: " + t.getMessage());
        }
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        WebSocketCloseCode webSocketCloseCode = WebSocketCloseCode.UnknownCode;
        try {
            webSocketCloseCode = WebSocketCloseCode.fromCode(statusCode);
        }
        catch (IllegalArgumentException e) {
            log.warn(String.format("onClose called with unrecognized statusCode %s and reason '%s'", statusCode, reason));
        }
        this.communicatorLifecycleListener.onClose(webSocketCloseCode);
        this.closeLatch.countDown();
        this.communicatorLifecycleListener.onDisconnect();
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
        try {
            this.communicatorLifecycleListener.onConnect(this.session);
        }
        catch (Throwable t) {
            this.communicatorLifecycleListener.onError(new ReasonThrowable("An error occurred while trying to get a session", t));
        }
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        log.debug("Received message <<\n" + msg);
        try {
            Message message = (Message)this.translator.fromJson(msg, (Type)((Object)Message.class));
            if (message != null) {
                switch (message.getOperationCode()) {
                    case Event: {
                        this.onEvent((Event)message);
                        break;
                    }
                    case RequestResponse: {
                        this.onRequestResponse((RequestResponse)message);
                        break;
                    }
                    case RequestBatchResponse: {
                        this.onRequestBatchResponse((RequestBatchResponse)message);
                        break;
                    }
                    case Hello: {
                        this.onHello((Hello)message);
                        break;
                    }
                    case Identified: {
                        this.onIdentified((Identified)message);
                        break;
                    }
                    default: {
                        this.communicatorLifecycleListener.onError(new ReasonThrowable("Invalid response type received", null));
                        break;
                    }
                }
            } else {
                this.communicatorLifecycleListener.onError(new ReasonThrowable("Received message was deserializable but had unknown format", null));
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            this.communicatorLifecycleListener.onError(new ReasonThrowable("Message received was not valid json: " + msg, jsonSyntaxException));
        }
        catch (Throwable t) {
            this.communicatorLifecycleListener.onError(new ReasonThrowable("Failed to process message from websocket due to unexpected exception", t));
        }
    }

    private void onEvent(Event event) {
        try {
            this.obsEventListener.onEvent(event);
        }
        catch (Throwable t) {
            this.communicatorLifecycleListener.onError(new ReasonThrowable("Failed to execute callback for Event: " + (Object)((Object)event.getMessageData().getEventType()), t));
        }
    }

    private void onRequestResponse(RequestResponse requestResponse) {
        try {
            this.obsRequestListener.onRequestResponse(requestResponse);
        }
        catch (Throwable t) {
            this.communicatorLifecycleListener.onError(new ReasonThrowable("Failed to execute callback for RequestResponse: " + (Object)((Object)requestResponse.getMessageData().getRequestType()), t));
        }
    }

    private void onRequestBatchResponse(RequestBatchResponse requestBatchResponse) {
        try {
            this.obsRequestListener.onRequestBatchResponse(requestBatchResponse);
        }
        catch (Throwable t) {
            this.communicatorLifecycleListener.onError(new ReasonThrowable("Failed to execute callback for RequestBatchResponse: " + requestBatchResponse, t));
        }
    }

    public void onHello(Hello hello) {
        log.debug(String.format("Rpc version %s. Authentication is required: %s", hello.getMessageData().getRpcVersion(), hello.isAuthenticationRequired()));
        if (hello.getMessageData().getRpcVersion() < RPC_VERSION) {
            this.onError(this.session, new IllegalStateException("Server doesn't support this client's RPC version"));
            return;
        }
        Identify.IdentifyBuilder identifyBuilder = Identify.builder().rpcVersion(RPC_VERSION);
        identifyBuilder.eventSubscriptions(this.obsEventListener.computeEventSubscription());
        if (hello.isAuthenticationRequired()) {
            String authentication = this.authenticator.computeAuthentication(hello.getMessageData().getAuthentication().getSalt(), hello.getMessageData().getAuthentication().getChallenge());
            identifyBuilder.authentication(authentication);
        }
        this.communicatorLifecycleListener.onHello(hello);
        this.sendMessage(identifyBuilder.build());
    }

    public void onIdentified(Identified identified) {
        this.communicatorLifecycleListener.onIdentified(identified);
        this.communicatorLifecycleListener.onReady();
    }

    private void send(String message) {
        log.debug("Sent message     >>\n" + message);
        if (this.session == null) {
            this.communicatorLifecycleListener.onError(new ReasonThrowable("Could not send message; no session established", null));
        } else {
            this.session.getRemote().sendStringByFuture(message);
        }
    }

    private void sendMessage(Message message) {
        this.send(this.translator.toJson(message));
    }

    public <R extends Request, RR extends RequestResponse> void sendRequest(R request, Consumer<RR> callback) {
        this.obsRequestListener.registerRequest(request, callback);
        this.sendMessage(request);
    }

    public void sendRequestBatch(RequestBatch requestBatch, Consumer<RequestBatchResponse> callback) {
        if (requestBatch.getData().getRequests() == null || requestBatch.getData().getRequests().isEmpty()) {
            throw new IllegalArgumentException("A RequestBatch must contain at least 1 request");
        }
        this.obsRequestListener.registerRequestBatch(requestBatch, callback);
        this.sendMessage(requestBatch);
    }
}

