/*
 * Decompiled with CFR 0.152.
 */
package io.obswebsocket.community.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockingConsumer<T>
implements Consumer<T> {
    private static final Logger log = LoggerFactory.getLogger(BlockingConsumer.class);
    private final CountDownLatch latch = new CountDownLatch(1);
    private T result;

    BlockingConsumer() {
    }

    @Override
    public void accept(T t) {
        this.result = t;
        this.latch.countDown();
    }

    public T get(long timeout) throws InterruptedException {
        if (!this.latch.await(timeout, TimeUnit.MILLISECONDS)) {
            log.warn("Timeout waiting for result");
        }
        return this.result;
    }
}

