/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.gradle.transform;

import io.objectbox.gradle.transform.ObjectBoxJavaTransform;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/objectbox/gradle/transform/ObjectBoxTestClassesTransformTask;", "Lorg/gradle/api/DefaultTask;", "()V", "compiledClasses", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCompiledClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "debug", "Lorg/gradle/api/provider/Property;", "", "getDebug", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "transformClasses", "", "ConfigAction", "agp-wrapper-3-4"})
public abstract class ObjectBoxTestClassesTransformTask
extends DefaultTask {
    @Input
    @NotNull
    public abstract Property<Boolean> getDebug();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getCompiledClasses();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public final void transformClasses() {
        File outputDir = (File)this.getOutputDir().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
        FilesKt.deleteRecursively((File)outputDir);
        outputDir.mkdirs();
        Object object = this.getDebug().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"debug.get()");
        new ObjectBoxJavaTransform(((Boolean)object).booleanValue()).transform(this.getCompiledClasses(), outputDir, false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/objectbox/gradle/transform/ObjectBoxTestClassesTransformTask$ConfigAction;", "Lorg/gradle/api/Action;", "Lio/objectbox/gradle/transform/ObjectBoxTestClassesTransformTask;", "debug", "Lorg/gradle/api/provider/Property;", "", "outputDir", "Ljava/io/File;", "inputClasspath", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/provider/Property;Ljava/io/File;Lorg/gradle/api/file/FileCollection;)V", "execute", "", "transformTask", "agp-wrapper-3-4"})
    public static final class ConfigAction
    implements Action<ObjectBoxTestClassesTransformTask> {
        @NotNull
        private final Property<Boolean> debug;
        @NotNull
        private final File outputDir;
        @NotNull
        private final FileCollection inputClasspath;

        public ConfigAction(@NotNull Property<Boolean> debug, @NotNull File outputDir, @NotNull FileCollection inputClasspath2) {
            Intrinsics.checkNotNullParameter(debug, (String)"debug");
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            Intrinsics.checkNotNullParameter((Object)inputClasspath2, (String)"inputClasspath");
            this.debug = debug;
            this.outputDir = outputDir;
            this.inputClasspath = inputClasspath2;
        }

        public void execute(@NotNull ObjectBoxTestClassesTransformTask transformTask) {
            Intrinsics.checkNotNullParameter((Object)((Object)transformTask), (String)"transformTask");
            transformTask.setGroup("objectbox");
            transformTask.setDescription("Transforms Java bytecode for local unit tests.");
            transformTask.getDebug().set((Provider)this.debug);
            transformTask.getOutputDir().set(this.outputDir);
            Object[] objectArray = new Object[]{this.inputClasspath};
            transformTask.getCompiledClasses().from(objectArray);
        }
    }
}

